/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue.filter;

import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.computation.task.projectanalysis.component.Component;

public class IssuePattern {
    private WildcardPattern componentPattern;
    private WildcardPattern rulePattern;

    public IssuePattern(String componentPattern, String rulePattern) {
        this.componentPattern = WildcardPattern.create((String)componentPattern);
        this.rulePattern = WildcardPattern.create((String)rulePattern);
    }

    public WildcardPattern getComponentPattern() {
        return this.componentPattern;
    }

    public WildcardPattern getRulePattern() {
        return this.rulePattern;
    }

    boolean match(DefaultIssue issue, Component component) {
        return this.matchComponent(component.getReportAttributes().getPath()) && this.matchRule(issue.ruleKey());
    }

    boolean matchRule(RuleKey rule) {
        return this.rulePattern.match(rule.toString());
    }

    boolean matchComponent(@Nullable String path) {
        return path != null && this.componentPattern.match(path);
    }

    public String toString() {
        return "IssuePattern{componentPattern=" + this.componentPattern + ", rulePattern=" + this.rulePattern + '}';
    }
}

