/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue.commonrule;

import com.google.common.base.Optional;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.issue.commonrule.CommonRule;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.projectanalysis.qualityprofile.ActiveRule;
import org.sonar.server.computation.task.projectanalysis.qualityprofile.ActiveRulesHolder;

public class TestErrorRule
extends CommonRule {
    private final MeasureRepository measureRepository;
    private final Metric testErrorMetric;
    private final Metric testFailureMetric;

    public TestErrorRule(ActiveRulesHolder activeRulesHolder, MeasureRepository measureRepository, MetricRepository metricRepository) {
        super(activeRulesHolder, "FailedUnitTests");
        this.measureRepository = measureRepository;
        this.testErrorMetric = metricRepository.getByKey("test_errors");
        this.testFailureMetric = metricRepository.getByKey("test_failures");
    }

    @Override
    protected CommonRule.CommonRuleIssue doProcessFile(Component file, ActiveRule activeRule) {
        int failures;
        Optional<Measure> errorsMeasure = this.measureRepository.getRawMeasure(file, this.testErrorMetric);
        Optional<Measure> failuresMeasure = this.measureRepository.getRawMeasure(file, this.testFailureMetric);
        int errors = errorsMeasure.isPresent() ? ((Measure)errorsMeasure.get()).getIntValue() : 0;
        int total = errors + (failures = failuresMeasure.isPresent() ? ((Measure)failuresMeasure.get()).getIntValue() : 0);
        if (total > 0) {
            String message = String.format("Fix failing unit tests on file \"%s\".", file.getName());
            return new CommonRule.CommonRuleIssue(total, message);
        }
        return null;
    }
}

