/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.db.protobuf.DbCommons;
import org.sonar.db.protobuf.DbIssues;
import org.sonar.server.computation.task.projectanalysis.analysis.Analysis;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.analysis.ScannerPlugin;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.issue.IssueVisitor;
import org.sonar.server.computation.task.projectanalysis.issue.Rule;
import org.sonar.server.computation.task.projectanalysis.issue.RuleRepository;
import org.sonar.server.computation.task.projectanalysis.qualityprofile.ActiveRule;
import org.sonar.server.computation.task.projectanalysis.qualityprofile.ActiveRulesHolder;
import org.sonar.server.computation.task.projectanalysis.scm.Changeset;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfoRepository;
import org.sonar.server.issue.IssueFieldsSetter;

public class IssueCreationDateCalculator
extends IssueVisitor {
    private final ScmInfoRepository scmInfoRepository;
    private final IssueFieldsSetter issueUpdater;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final IssueChangeContext changeContext;
    private final ActiveRulesHolder activeRulesHolder;
    private final RuleRepository ruleRepository;

    public IssueCreationDateCalculator(AnalysisMetadataHolder analysisMetadataHolder, ScmInfoRepository scmInfoRepository, IssueFieldsSetter issueUpdater, ActiveRulesHolder activeRulesHolder, RuleRepository ruleRepository) {
        this.scmInfoRepository = scmInfoRepository;
        this.issueUpdater = issueUpdater;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.ruleRepository = ruleRepository;
        this.changeContext = IssueChangeContext.createScan((Date)new Date(analysisMetadataHolder.getAnalysisDate()));
        this.activeRulesHolder = activeRulesHolder;
    }

    @Override
    public void onIssue(Component component, DefaultIssue issue) {
        if (!issue.isNew()) {
            return;
        }
        Optional<Long> lastAnalysisOptional = this.lastAnalysis();
        boolean firstAnalysis = !lastAnalysisOptional.isPresent();
        Rule rule = this.ruleRepository.findByKey(issue.getRuleKey()).orElseThrow(IssueCreationDateCalculator.illegalStateException("The rule with key '%s' raised an issue, but no rule with that key was found", issue.getRuleKey()));
        if (rule.isExternal()) {
            this.getScmChangeDate(component, issue).ifPresent(changeDate -> this.updateDate(issue, (Date)changeDate));
        } else {
            ActiveRule activeRule = (ActiveRule)this.activeRulesHolder.get(issue.getRuleKey()).get();
            if (firstAnalysis || IssueCreationDateCalculator.activeRuleIsNew(activeRule, lastAnalysisOptional.get()) || this.ruleImplementationChanged(activeRule.getRuleKey(), activeRule.getPluginKey(), lastAnalysisOptional.get())) {
                this.getScmChangeDate(component, issue).ifPresent(changeDate -> this.updateDate(issue, (Date)changeDate));
            }
        }
    }

    private boolean ruleImplementationChanged(RuleKey ruleKey, @Nullable String pluginKey, long lastAnalysisDate) {
        if (pluginKey == null) {
            return false;
        }
        ScannerPlugin scannerPlugin = Optional.ofNullable(this.analysisMetadataHolder.getScannerPluginsByKey().get(pluginKey)).orElseThrow(IssueCreationDateCalculator.illegalStateException("The rule %s is declared to come from plugin %s, but this plugin was not used by scanner.", ruleKey, pluginKey));
        return IssueCreationDateCalculator.pluginIsNew(scannerPlugin, lastAnalysisDate) || this.basePluginIsNew(scannerPlugin, lastAnalysisDate);
    }

    private boolean basePluginIsNew(ScannerPlugin scannerPlugin, long lastAnalysisDate) {
        String basePluginKey = scannerPlugin.getBasePluginKey();
        if (basePluginKey == null) {
            return false;
        }
        ScannerPlugin basePlugin = this.analysisMetadataHolder.getScannerPluginsByKey().get(basePluginKey);
        return lastAnalysisDate < basePlugin.getUpdatedAt();
    }

    private static boolean pluginIsNew(ScannerPlugin scannerPlugin, long lastAnalysisDate) {
        return lastAnalysisDate < scannerPlugin.getUpdatedAt();
    }

    private static boolean activeRuleIsNew(ActiveRule activeRule, Long lastAnalysisDate) {
        long ruleCreationDate = activeRule.getCreatedAt();
        return lastAnalysisDate < ruleCreationDate;
    }

    private Optional<Date> getScmChangeDate(Component component, DefaultIssue issue) {
        return this.getScmInfo(component).flatMap(scmInfo -> IssueCreationDateCalculator.getChangeset(component, scmInfo, issue)).map(IssueCreationDateCalculator::getChangeDate);
    }

    private Optional<Long> lastAnalysis() {
        return Optional.ofNullable(this.analysisMetadataHolder.getBaseAnalysis()).map(Analysis::getCreatedAt);
    }

    private Optional<ScmInfo> getScmInfo(Component component) {
        return this.scmInfoRepository.getScmInfo(component);
    }

    private static Optional<Changeset> getChangeset(Component component, ScmInfo scmInfo, DefaultIssue issue) {
        HashSet<Integer> involvedLines = new HashSet<Integer>();
        DbIssues.Locations locations = (DbIssues.Locations)issue.getLocations();
        if (locations != null) {
            if (locations.hasTextRange()) {
                IssueCreationDateCalculator.addLines(involvedLines, locations.getTextRange());
            }
            for (DbIssues.Flow f : locations.getFlowList()) {
                for (DbIssues.Location l : f.getLocationList()) {
                    if (!Objects.equals(l.getComponentId(), component.getUuid())) continue;
                    IssueCreationDateCalculator.addLines(involvedLines, l.getTextRange());
                }
            }
            if (!involvedLines.isEmpty()) {
                return involvedLines.stream().filter(scmInfo::hasChangesetForLine).map(scmInfo::getChangesetForLine).max(Comparator.comparingLong(Changeset::getDate));
            }
        }
        return Optional.of(scmInfo.getLatestChangeset());
    }

    private static void addLines(Set<Integer> involvedLines, DbCommons.TextRange range) {
        IntStream.rangeClosed(range.getStartLine(), range.getEndLine()).forEach(involvedLines::add);
    }

    private static Date getChangeDate(Changeset changesetForLine) {
        return DateUtils.longToDate((Long)changesetForLine.getDate());
    }

    private void updateDate(DefaultIssue issue, Date scmDate) {
        this.issueUpdater.setCreationDate(issue, scmDate, this.changeContext);
    }

    private static Supplier<? extends IllegalStateException> illegalStateException(String str, Object ... args) {
        return () -> new IllegalStateException(String.format(str, args));
    }
}

