/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.filemove;

import java.util.List;
import org.sonar.server.computation.task.projectanalysis.filemove.SourceSimilarity;

public class SourceSimilarityImpl
implements SourceSimilarity {
    @Override
    public <T> int score(List<T> left, List<T> right) {
        if (left.isEmpty() && right.isEmpty()) {
            return 0;
        }
        int distance = SourceSimilarityImpl.levenshteinDistance(left, right);
        return (int)(100.0 * (1.0 - (double)distance / (double)Math.max(left.size(), right.size())));
    }

    private static <T> int levenshteinDistance(List<T> left, List<T> right) {
        int len0 = left.size() + 1;
        int len1 = right.size() + 1;
        int[] cost = new int[len0];
        int[] newcost = new int[len0];
        for (int i = 0; i < len0; ++i) {
            cost[i] = i;
        }
        for (int j = 1; j < len1; ++j) {
            newcost[0] = j;
            for (int i = 1; i < len0; ++i) {
                int match = left.get(i - 1).equals(right.get(j - 1)) ? 0 : 1;
                int costReplace = cost[i - 1] + match;
                int costInsert = cost[i] + 1;
                int costDelete = newcost[i - 1] + 1;
                newcost[i] = Math.min(Math.min(costInsert, costDelete), costReplace);
            }
            int[] swap = cost;
            cost = newcost;
            newcost = swap;
        }
        return cost[len0 - 1];
    }
}

