/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentCrawler;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DequeBasedPath;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareVisitor;
import org.sonar.server.computation.task.projectanalysis.component.PathElementImpl;
import org.sonar.server.computation.task.projectanalysis.component.VisitException;

public final class PathAwareCrawler<T>
implements ComponentCrawler {
    private final PathAwareVisitor<T> visitor;
    private final DequeBasedPath<T> stack = new DequeBasedPath();

    public PathAwareCrawler(PathAwareVisitor<T> visitor) {
        this.visitor = Objects.requireNonNull(visitor);
    }

    @Override
    public void visit(Component component) {
        try {
            this.visitImpl(component);
        }
        catch (RuntimeException e) {
            VisitException.rethrowOrWrap(e, "Visit failed for Component {key=%s,type=%s} %s", new Object[]{component.getKey(), component.getType(), new ComponentPathPrinter(this.stack)});
        }
    }

    private void visitImpl(Component component) {
        if (!this.verifyDepth(component)) {
            return;
        }
        this.stack.add(new PathElementImpl<T>(component, this.createForComponent(component)));
        if (this.visitor.getOrder() == ComponentVisitor.Order.PRE_ORDER) {
            this.visitNode(component);
        }
        this.visitChildren(component);
        if (this.visitor.getOrder() == ComponentVisitor.Order.POST_ORDER) {
            this.visitNode(component);
        }
        this.stack.pop();
    }

    private boolean verifyDepth(Component component) {
        CrawlerDepthLimit maxDepth = this.visitor.getMaxDepth();
        return maxDepth.isSameAs(component.getType()) || maxDepth.isDeeperThan(component.getType());
    }

    private void visitChildren(Component component) {
        for (Component child : component.getChildren()) {
            if (!this.verifyDepth(component)) continue;
            this.visit(child);
        }
    }

    private void visitNode(Component component) {
        this.visitor.visitAny(component, this.stack);
        switch (component.getType()) {
            case PROJECT: {
                this.visitor.visitProject(component, this.stack);
                break;
            }
            case MODULE: {
                this.visitor.visitModule(component, this.stack);
                break;
            }
            case DIRECTORY: {
                this.visitor.visitDirectory(component, this.stack);
                break;
            }
            case FILE: {
                this.visitor.visitFile(component, this.stack);
                break;
            }
            case VIEW: {
                this.visitor.visitView(component, this.stack);
                break;
            }
            case SUBVIEW: {
                this.visitor.visitSubView(component, this.stack);
                break;
            }
            case PROJECT_VIEW: {
                this.visitor.visitProjectView(component, this.stack);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported component type %s, no visitor method to call", new Object[]{component.getType()}));
            }
        }
    }

    private T createForComponent(Component component) {
        switch (component.getType()) {
            case PROJECT: {
                return this.visitor.getFactory().createForProject(component);
            }
            case MODULE: {
                return this.visitor.getFactory().createForModule(component);
            }
            case DIRECTORY: {
                return this.visitor.getFactory().createForDirectory(component);
            }
            case FILE: {
                return this.visitor.getFactory().createForFile(component);
            }
            case VIEW: {
                return this.visitor.getFactory().createForView(component);
            }
            case SUBVIEW: {
                return this.visitor.getFactory().createForSubView(component);
            }
            case PROJECT_VIEW: {
                return this.visitor.getFactory().createForProjectView(component);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported component type %s, can not create stack object", new Object[]{component.getType()}));
    }

    @Immutable
    private static final class ComponentPathPrinter<T> {
        private static final Joiner PATH_ELEMENTS_JOINER = Joiner.on((String)"->");
        private final DequeBasedPath<T> currentPath;

        private ComponentPathPrinter(DequeBasedPath<T> currentPath) {
            this.currentPath = currentPath;
        }

        public String toString() {
            if (this.currentPath.isRoot()) {
                return "";
            }
            return " located " + ComponentPathPrinter.toKeyPath(this.currentPath);
        }

        private static <T> String toKeyPath(Iterable<PathAwareVisitor.PathElement<T>> currentPath) {
            return PATH_ELEMENTS_JOINER.join((Iterable)FluentIterable.from(currentPath).transform((Function)PathElementToComponentAsString.INSTANCE).skip(1));
        }

        private static enum PathElementToComponentAsString implements Function<PathAwareVisitor.PathElement<?>, String>
        {
            INSTANCE;


            @Nonnull
            public String apply(@Nonnull PathAwareVisitor.PathElement<?> input) {
                return String.format("%s(type=%s)", new Object[]{input.getComponent().getKey(), input.getComponent().getType()});
            }
        }
    }
}

