/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.es.EsQueueDto;
import org.sonar.server.component.index.ComponentDoc;
import org.sonar.server.component.index.ComponentIndexDefinition;
import org.sonar.server.es.BulkIndexer;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.IndexingResult;
import org.sonar.server.es.OneToManyResilientIndexingListener;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.permission.index.AuthorizationScope;
import org.sonar.server.permission.index.NeedAuthorizationIndexer;

public class ComponentIndexer
implements ProjectIndexer,
NeedAuthorizationIndexer {
    private static final AuthorizationScope AUTHORIZATION_SCOPE = new AuthorizationScope(ComponentIndexDefinition.INDEX_TYPE_COMPONENT, project -> true);
    private static final ImmutableSet<IndexType> INDEX_TYPES = ImmutableSet.of((Object)ComponentIndexDefinition.INDEX_TYPE_COMPONENT);
    private final DbClient dbClient;
    private final EsClient esClient;

    public ComponentIndexer(DbClient dbClient, EsClient esClient) {
        this.dbClient = dbClient;
        this.esClient = esClient;
    }

    @Override
    public Set<IndexType> getIndexTypes() {
        return INDEX_TYPES;
    }

    @Override
    public void indexOnStartup(Set<IndexType> uninitializedIndexTypes) {
        this.doIndexByProjectUuid(null, BulkIndexer.Size.LARGE);
    }

    @Override
    public void indexOnAnalysis(String branchUuid) {
        this.doIndexByProjectUuid(branchUuid, BulkIndexer.Size.REGULAR);
    }

    @Override
    public AuthorizationScope getAuthorizationScope() {
        return AUTHORIZATION_SCOPE;
    }

    @Override
    public Collection<EsQueueDto> prepareForRecovery(DbSession dbSession, Collection<String> projectUuids, ProjectIndexer.Cause cause) {
        switch (cause) {
            case MEASURE_CHANGE: 
            case PROJECT_TAGS_UPDATE: 
            case PERMISSION_CHANGE: {
                return Collections.emptyList();
            }
            case PROJECT_CREATION: 
            case PROJECT_DELETION: 
            case PROJECT_KEY_UPDATE: {
                List items = (List)projectUuids.stream().map(branchUuid -> EsQueueDto.create((String)ComponentIndexDefinition.INDEX_TYPE_COMPONENT.format(), (String)branchUuid, null, (String)branchUuid)).collect(MoreCollectors.toArrayList((int)projectUuids.size()));
                return this.dbClient.esQueueDao().insert(dbSession, (Collection)items);
            }
        }
        throw new IllegalStateException("Unsupported cause: " + (Object)((Object)cause));
    }

    @Override
    public IndexingResult index(DbSession dbSession, Collection<EsQueueDto> items) {
        if (items.isEmpty()) {
            return new IndexingResult();
        }
        OneToManyResilientIndexingListener listener = new OneToManyResilientIndexingListener(this.dbClient, dbSession, items);
        BulkIndexer bulkIndexer = new BulkIndexer(this.esClient, ComponentIndexDefinition.INDEX_TYPE_COMPONENT, BulkIndexer.Size.REGULAR, listener);
        bulkIndexer.start();
        Set branchUuids = (Set)items.stream().map(EsQueueDto::getDocId).collect(MoreCollectors.toHashSet((int)items.size()));
        HashSet remaining = new HashSet(branchUuids);
        for (String branchUuid : branchUuids) {
            this.dbClient.componentDao().scrollForIndexing(dbSession, branchUuid, context -> {
                ComponentDto dto = (ComponentDto)context.getResultObject();
                bulkIndexer.add(ComponentIndexer.newIndexRequest(ComponentIndexer.toDocument(dto)));
                remaining.remove(dto.projectUuid());
            });
        }
        remaining.forEach(projectUuid -> this.addProjectDeletionToBulkIndexer(bulkIndexer, (String)projectUuid));
        return bulkIndexer.stop();
    }

    private void doIndexByProjectUuid(@Nullable String projectUuid, BulkIndexer.Size bulkSize) {
        BulkIndexer bulk = new BulkIndexer(this.esClient, ComponentIndexDefinition.INDEX_TYPE_COMPONENT, bulkSize);
        bulk.start();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.componentDao().scrollForIndexing(dbSession, projectUuid, context -> {
                ComponentDto dto = (ComponentDto)context.getResultObject();
                bulk.add(ComponentIndexer.newIndexRequest(ComponentIndexer.toDocument(dto)));
            });
        }
        bulk.stop();
    }

    private void addProjectDeletionToBulkIndexer(BulkIndexer bulkIndexer, String projectUuid) {
        SearchRequestBuilder searchRequest = this.esClient.prepareSearch(ComponentIndexDefinition.INDEX_TYPE_COMPONENT).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"project_uuid", (String)projectUuid)).setRouting(projectUuid);
        bulkIndexer.addDeletion(searchRequest);
    }

    public void delete(String projectUuid, Collection<String> disabledComponentUuids) {
        BulkIndexer bulk = new BulkIndexer(this.esClient, ComponentIndexDefinition.INDEX_TYPE_COMPONENT, BulkIndexer.Size.REGULAR);
        bulk.start();
        disabledComponentUuids.forEach(uuid -> bulk.addDeletion(ComponentIndexDefinition.INDEX_TYPE_COMPONENT, (String)uuid, projectUuid));
        bulk.stop();
    }

    @VisibleForTesting
    void index(ComponentDto ... docs) {
        BulkIndexer bulk = new BulkIndexer(this.esClient, ComponentIndexDefinition.INDEX_TYPE_COMPONENT, BulkIndexer.Size.REGULAR);
        bulk.start();
        Arrays.stream(docs).map(ComponentIndexer::toDocument).map(ComponentIndexer::newIndexRequest).forEach(bulk::add);
        bulk.stop();
    }

    private static IndexRequest newIndexRequest(ComponentDoc doc) {
        return new IndexRequest(ComponentIndexDefinition.INDEX_TYPE_COMPONENT.getIndex(), ComponentIndexDefinition.INDEX_TYPE_COMPONENT.getType(), doc.getId()).routing(doc.getRouting()).parent(doc.getParent()).source(doc.getFields());
    }

    public static ComponentDoc toDocument(ComponentDto component) {
        return new ComponentDoc().setId(component.uuid()).setName(component.name()).setKey(component.getDbKey()).setProjectUuid(component.projectUuid()).setOrganization(component.getOrganizationUuid()).setLanguage(component.language()).setQualifier(component.qualifier());
    }
}

