/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.sonar.api.i18n.I18n;
import org.sonar.api.utils.System2;
import org.sonar.core.component.ComponentKeys;
import org.sonar.core.util.Uuids;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.component.NewComponent;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.es.ProjectIndexers;
import org.sonar.server.favorite.FavoriteUpdater;
import org.sonar.server.permission.PermissionTemplateService;
import org.sonar.server.ws.WsUtils;

public class ComponentUpdater {
    private final DbClient dbClient;
    private final I18n i18n;
    private final System2 system2;
    private final PermissionTemplateService permissionTemplateService;
    private final FavoriteUpdater favoriteUpdater;
    private final ProjectIndexers projectIndexers;

    public ComponentUpdater(DbClient dbClient, I18n i18n, System2 system2, PermissionTemplateService permissionTemplateService, FavoriteUpdater favoriteUpdater, ProjectIndexers projectIndexers) {
        this.dbClient = dbClient;
        this.i18n = i18n;
        this.system2 = system2;
        this.permissionTemplateService = permissionTemplateService;
        this.favoriteUpdater = favoriteUpdater;
        this.projectIndexers = projectIndexers;
    }

    public ComponentDto create(DbSession dbSession, NewComponent newComponent, @Nullable Integer userId) {
        this.checkKeyFormat(newComponent.qualifier(), newComponent.key());
        ComponentDto componentDto = this.createRootComponent(dbSession, newComponent);
        if (ComponentUpdater.isRootProject(componentDto)) {
            this.createBranch(dbSession, componentDto.uuid());
        }
        this.removeDuplicatedProjects(dbSession, componentDto.getDbKey());
        this.handlePermissionTemplate(dbSession, componentDto, newComponent.getOrganizationUuid(), userId);
        this.projectIndexers.commitAndIndex(dbSession, Collections.singletonList(componentDto), ProjectIndexer.Cause.PROJECT_CREATION);
        return componentDto;
    }

    private ComponentDto createRootComponent(DbSession session, NewComponent newComponent) {
        this.checkBranchFormat(newComponent.qualifier(), newComponent.branch());
        String keyWithBranch = ComponentKeys.createKey((String)newComponent.key(), (String)newComponent.branch());
        WsUtils.checkRequest(!this.dbClient.componentDao().selectByKey(session, keyWithBranch).isPresent(), "Could not create %s, key already exists: %s", this.getQualifierToDisplay(newComponent.qualifier()), keyWithBranch);
        String uuid = Uuids.create();
        ComponentDto component = new ComponentDto().setOrganizationUuid(newComponent.getOrganizationUuid()).setUuid(uuid).setUuidPath(".").setRootUuid(uuid).setModuleUuid(null).setModuleUuidPath("." + uuid + ".").setProjectUuid(uuid).setDbKey(keyWithBranch).setDeprecatedKey(keyWithBranch).setName(newComponent.name()).setLongName(newComponent.name()).setScope("PRJ").setQualifier(newComponent.qualifier()).setPrivate(newComponent.isPrivate()).setCreatedAt(new Date(this.system2.now()));
        this.dbClient.componentDao().insert(session, component);
        return component;
    }

    private static boolean isRootProject(ComponentDto componentDto) {
        return "PRJ".equals(componentDto.scope()) && "TRK".equals(componentDto.qualifier());
    }

    private BranchDto createBranch(DbSession session, String componentUuid) {
        BranchDto branch = new BranchDto().setBranchType(BranchType.LONG).setUuid(componentUuid).setKey("master").setMergeBranchUuid(null).setProjectUuid(componentUuid);
        this.dbClient.branchDao().upsert(session, branch);
        return branch;
    }

    private void removeDuplicatedProjects(DbSession session, String projectKey) {
        List duplicated = this.dbClient.componentDao().selectComponentsHavingSameKeyOrderedById(session, projectKey);
        for (int i = 1; i < duplicated.size(); ++i) {
            this.dbClient.componentDao().delete(session, ((ComponentDto)duplicated.get(i)).getId().longValue());
        }
    }

    private void handlePermissionTemplate(DbSession dbSession, ComponentDto componentDto, String organizationUuid, @Nullable Integer userId) {
        this.permissionTemplateService.applyDefault(dbSession, organizationUuid, componentDto, userId);
        if (componentDto.qualifier().equals("TRK") && this.permissionTemplateService.hasDefaultTemplateWithPermissionOnProjectCreator(dbSession, organizationUuid, componentDto)) {
            this.favoriteUpdater.add(dbSession, componentDto, userId);
        }
    }

    private void checkKeyFormat(String qualifier, String key) {
        WsUtils.checkRequest(ComponentKeys.isValidModuleKey((String)key), "Malformed key for %s: %s. Allowed characters are alphanumeric, '-', '_', '.' and ':', with at least one non-digit.", this.getQualifierToDisplay(qualifier), key);
    }

    private void checkBranchFormat(String qualifier, @Nullable String branch) {
        WsUtils.checkRequest(branch == null || ComponentKeys.isValidBranch((String)branch), "Malformed branch for %s: %s. Allowed characters are alphanumeric, '-', '_', '.' and '/', with at least one non-digit.", this.getQualifierToDisplay(qualifier), branch);
    }

    private String getQualifierToDisplay(String qualifier) {
        return this.i18n.message(Locale.getDefault(), "qualifier." + qualifier, "Project", new Object[0]);
    }
}

