/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeActivityDto;
import org.sonar.db.ce.CeQueueDto;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.ce.ws.CeWsAction;
import org.sonar.server.ce.ws.TaskFormatter;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Ce;

public class TaskAction
implements CeWsAction {
    public static final String ACTION = "task";
    public static final String PARAM_TASK_UUID = "id";
    private static final String PARAM_ADDITIONAL_FIELDS = "additionalFields";
    private final DbClient dbClient;
    private final TaskFormatter wsTaskFormatter;
    private final UserSession userSession;

    public TaskAction(DbClient dbClient, TaskFormatter wsTaskFormatter, UserSession userSession) {
        this.dbClient = dbClient;
        this.wsTaskFormatter = wsTaskFormatter;
        this.userSession = userSession;
    }

    @Override
    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction(ACTION).setDescription("Give Compute Engine task details such as type, status, duration and associated component.<br />Requires 'Administer System' or 'Execute Analysis' permission.<br/>Since 6.1, field \"logs\" is deprecated and its value is always false.").setResponseExample(this.getClass().getResource("task-example.json")).setSince("5.2").setChangelog(new Change[]{new Change("6.6", "fields \"branch\" and \"branchType\" added")}).setHandler((RequestHandler)this);
        action.createParam(PARAM_TASK_UUID).setRequired(true).setDescription("Id of task").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam(PARAM_ADDITIONAL_FIELDS).setSince("6.1").setDescription("Comma-separated list of the optional fields to be returned in response.").setPossibleValues(AdditionalField.possibleValues());
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        String taskUuid = wsRequest.mandatoryParam(PARAM_TASK_UUID);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Ce.TaskResponse.Builder wsTaskResponse = Ce.TaskResponse.newBuilder();
            Optional queueDto = this.dbClient.ceQueueDao().selectByUuid(dbSession, taskUuid);
            if (queueDto.isPresent()) {
                com.google.common.base.Optional<ComponentDto> component = this.loadComponent(dbSession, ((CeQueueDto)queueDto.get()).getComponentUuid());
                this.checkPermission(component);
                wsTaskResponse.setTask(this.wsTaskFormatter.formatQueue(dbSession, (CeQueueDto)queueDto.get()));
            } else {
                CeActivityDto ceActivityDto = (CeActivityDto)WsUtils.checkFoundWithOptional(this.dbClient.ceActivityDao().selectByUuid(dbSession, taskUuid), "No activity found for task '%s'", taskUuid);
                com.google.common.base.Optional<ComponentDto> component = this.loadComponent(dbSession, ceActivityDto.getComponentUuid());
                this.checkPermission(component);
                Set<AdditionalField> additionalFields = AdditionalField.getFromRequest(wsRequest);
                TaskAction.maskErrorStacktrace(ceActivityDto, additionalFields);
                wsTaskResponse.setTask(this.wsTaskFormatter.formatActivity(dbSession, ceActivityDto, this.extractScannerContext(dbSession, ceActivityDto, additionalFields)));
            }
            WsUtils.writeProtobuf((Message)wsTaskResponse.build(), wsRequest, wsResponse);
        }
    }

    private com.google.common.base.Optional<ComponentDto> loadComponent(DbSession dbSession, @Nullable String projectUuid) {
        if (projectUuid == null) {
            return com.google.common.base.Optional.absent();
        }
        return this.dbClient.componentDao().selectByUuid(dbSession, projectUuid);
    }

    private void checkPermission(com.google.common.base.Optional<ComponentDto> component) {
        if (component.isPresent()) {
            String orgUuid = ((ComponentDto)component.get()).getOrganizationUuid();
            if (!(this.userSession.hasPermission(OrganizationPermission.ADMINISTER, orgUuid) || this.userSession.hasPermission(OrganizationPermission.SCAN, orgUuid) || this.userSession.hasComponentPermission("scan", (ComponentDto)component.get()))) {
                throw AbstractUserSession.insufficientPrivilegesException();
            }
        } else {
            this.userSession.checkIsSystemAdministrator();
        }
    }

    private static void maskErrorStacktrace(CeActivityDto ceActivityDto, Set<AdditionalField> additionalFields) {
        if (!additionalFields.contains((Object)AdditionalField.STACKTRACE)) {
            ceActivityDto.setErrorStacktrace(null);
        }
    }

    @CheckForNull
    private String extractScannerContext(DbSession dbSession, CeActivityDto activityDto, Set<AdditionalField> additionalFields) {
        if (additionalFields.contains((Object)AdditionalField.SCANNER_CONTEXT)) {
            return this.dbClient.ceScannerContextDao().selectScannerContext(dbSession, activityDto.getUuid()).orElse(null);
        }
        return null;
    }

    private static enum AdditionalField {
        STACKTRACE("stacktrace"),
        SCANNER_CONTEXT("scannerContext");

        private final String label;

        private AdditionalField(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static Set<AdditionalField> getFromRequest(Request wsRequest) {
            List strings = wsRequest.paramAsStrings(TaskAction.PARAM_ADDITIONAL_FIELDS);
            if (strings == null) {
                return Collections.emptySet();
            }
            return (Set)strings.stream().map(s -> {
                for (AdditionalField field : AdditionalField.values()) {
                    if (!field.label.equalsIgnoreCase((String)s)) continue;
                    return field;
                }
                return null;
            }).filter(Objects::nonNull).collect(MoreCollectors.toSet());
        }

        public static Collection<String> possibleValues() {
            return (Collection)Arrays.stream(AdditionalField.values()).map(AdditionalField::getLabel).collect(MoreCollectors.toList((int)AdditionalField.values().length));
        }
    }
}

