/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import com.google.protobuf.Message;
import java.io.BufferedInputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.ce.queue.CeTask;
import org.sonar.server.ce.ws.CeWsAction;
import org.sonar.server.computation.queue.ReportSubmitter;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Ce;

public class SubmitAction
implements CeWsAction {
    private static final String PARAM_ORGANIZATION_KEY = "organization";
    private static final String PARAM_PROJECT_KEY = "projectKey";
    private static final String PARAM_PROJECT_BRANCH = "projectBranch";
    private static final String PARAM_PROJECT_NAME = "projectName";
    private static final String PARAM_REPORT_DATA = "report";
    private static final String PARAM_ANALYSIS_CHARACTERISTIC = "characteristic";
    private final ReportSubmitter reportSubmitter;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public SubmitAction(ReportSubmitter reportSubmitter, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.reportSubmitter = reportSubmitter;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    @Override
    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("submit").setDescription("Submits a scanner report to the queue. Report is processed asynchronously. Requires analysis permission. If the project does not exist, then the provisioning permission is also required.").setPost(true).setInternal(true).setSince("5.2").setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("submit-example.json"));
        action.createParam(PARAM_ORGANIZATION_KEY).setDescription("Key of the organization the project belongs to").setExampleValue((Object)"my-org").setSince("6.3").setInternal(true);
        action.createParam(PARAM_PROJECT_KEY).setRequired(true).setMaximumLength(Integer.valueOf(400)).setDescription("Key of project").setExampleValue((Object)"my_project");
        action.createParam(PARAM_PROJECT_BRANCH).setDescription("Optional branch of project").setExampleValue((Object)"branch-1.x");
        action.createParam(PARAM_PROJECT_NAME).setRequired(false).setDescription("Optional name of the project, used only if the project does not exist yet. If name is longer than %d, it is abbreviated.", new Object[]{500}).setExampleValue((Object)"My Project");
        action.createParam(PARAM_REPORT_DATA).setRequired(true).setDescription("Report file. Format is not an API, it changes among SonarQube versions.");
        action.createParam(PARAM_ANALYSIS_CHARACTERISTIC).setRequired(false).setDescription("Optional characteristic of the analysis. Can be repeated to define multiple characteristics.").setExampleValue((Object)"branchType=long").setSince("6.6");
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        String organizationKey = (String)wsRequest.getParam(PARAM_ORGANIZATION_KEY).emptyAsNull().or(this.defaultOrganizationProvider.get()::getKey);
        String projectKey = wsRequest.mandatoryParam(PARAM_PROJECT_KEY);
        String projectBranch = wsRequest.param(PARAM_PROJECT_BRANCH);
        String projectName = StringUtils.abbreviate((String)StringUtils.defaultIfBlank((String)wsRequest.param(PARAM_PROJECT_NAME), (String)projectKey), (int)500);
        Map<String, String> characteristics = SubmitAction.parseTaskCharacteristics(wsRequest);
        try (BufferedInputStream report = new BufferedInputStream(wsRequest.mandatoryParamAsPart(PARAM_REPORT_DATA).getInputStream());){
            CeTask task = this.reportSubmitter.submit(organizationKey, projectKey, projectBranch, projectName, characteristics, report);
            Ce.SubmitResponse submitResponse = Ce.SubmitResponse.newBuilder().setTaskId(task.getUuid()).setProjectId(task.getComponentUuid()).build();
            WsUtils.writeProtobuf((Message)submitResponse, wsRequest, wsResponse);
        }
    }

    private static Map<String, String> parseTaskCharacteristics(Request wsRequest) {
        LinkedHashMap<String, String> characteristics = new LinkedHashMap<String, String>();
        for (String param : wsRequest.multiParam(PARAM_ANALYSIS_CHARACTERISTIC)) {
            String[] pair = StringUtils.split((String)param, (String)"=", (int)2);
            WsUtils.checkRequest(pair.length == 2, "Parameter '%s' must be a key-value pair with the format 'key=value'.", PARAM_ANALYSIS_CHARACTERISTIC);
            WsUtils.checkRequest(!characteristics.containsKey(pair[0]), "Key '%s' was provided twice with parameters '%s'", pair[0], PARAM_ANALYSIS_CHARACTERISTIC);
            characteristics.put(pair[0], pair[1]);
        }
        return characteristics;
    }
}

