/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.batch;

import com.google.protobuf.Message;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.scanner.protocol.input.FileData;
import org.sonar.scanner.protocol.input.ProjectRepositories;
import org.sonar.server.batch.BatchWsAction;
import org.sonar.server.batch.ProjectDataLoader;
import org.sonar.server.batch.ProjectDataQuery;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Batch;

public class ProjectAction
implements BatchWsAction {
    private static final String PARAM_KEY = "key";
    private static final String PARAM_PROFILE = "profile";
    private static final String PARAM_ISSUES_MODE = "issues_mode";
    private static final String PARAM_BRANCH = "branch";
    private static final String PARAM_PULL_REQUEST = "pullRequest";
    private final ProjectDataLoader projectDataLoader;

    public ProjectAction(ProjectDataLoader projectDataLoader) {
        this.projectDataLoader = projectDataLoader;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("project").setDescription("Return project repository").setResponseExample(this.getClass().getResource("project-example.json")).setSince("4.5").setInternal(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_KEY).setRequired(true).setDescription("Project or module key").setExampleValue((Object)"my_project");
        action.createParam(PARAM_PROFILE).setDescription("Profile name").setExampleValue((Object)"SonarQube Way");
        action.createParam(PARAM_ISSUES_MODE).setDescription("Issues mode or not").setDefaultValue((Object)false).setBooleanPossibleValues();
        action.createParam(PARAM_BRANCH).setSince("6.6").setDescription("Branch key").setExampleValue((Object)"feature/my_branch");
        action.createParam(PARAM_PULL_REQUEST).setSince("7.1").setDescription("Pull request id").setExampleValue((Object)"5461");
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        ProjectRepositories data = this.projectDataLoader.load(ProjectDataQuery.create().setModuleKey(wsRequest.mandatoryParam(PARAM_KEY)).setProfileName(wsRequest.param(PARAM_PROFILE)).setIssuesMode(wsRequest.mandatoryParamAsBoolean(PARAM_ISSUES_MODE)).setBranch(wsRequest.param(PARAM_BRANCH)).setPullRequest(wsRequest.param(PARAM_PULL_REQUEST)));
        Batch.WsProjectResponse projectResponse = ProjectAction.buildResponse(data);
        WsUtils.writeProtobuf((Message)projectResponse, wsRequest, wsResponse);
    }

    private static Batch.WsProjectResponse buildResponse(ProjectRepositories data) {
        Batch.WsProjectResponse.Builder response = Batch.WsProjectResponse.newBuilder();
        Protobuf.setNullable((Object)data.lastAnalysisDate(), arg_0 -> ((Batch.WsProjectResponse.Builder)response).setLastAnalysisDate(arg_0), Date::getTime);
        response.setTimestamp(data.timestamp());
        response.getMutableFileDataByModuleAndPath().putAll(ProjectAction.buildFileDataByModuleAndPath(data));
        response.getMutableSettingsByModule().putAll(ProjectAction.buildSettingsByModule(data));
        return response.build();
    }

    private static Map<String, Batch.WsProjectResponse.FileDataByPath> buildFileDataByModuleAndPath(ProjectRepositories data) {
        HashMap<String, Batch.WsProjectResponse.FileDataByPath> fileDataByModuleAndPathResponse = new HashMap<String, Batch.WsProjectResponse.FileDataByPath>();
        for (Map.Entry moduleAndFileDataByPathEntry : data.fileDataByModuleAndPath().entrySet()) {
            fileDataByModuleAndPathResponse.put((String)moduleAndFileDataByPathEntry.getKey(), ProjectAction.buildFileDataByPath((Map)moduleAndFileDataByPathEntry.getValue()));
        }
        return fileDataByModuleAndPathResponse;
    }

    private static Batch.WsProjectResponse.FileDataByPath buildFileDataByPath(Map<String, FileData> fileDataByPath) {
        Batch.WsProjectResponse.FileDataByPath.Builder response = Batch.WsProjectResponse.FileDataByPath.newBuilder();
        Map fileDataByPathResponse = response.getMutableFileDataByPath();
        for (Map.Entry<String, FileData> pathFileDataEntry : fileDataByPath.entrySet()) {
            fileDataByPathResponse.put(pathFileDataEntry.getKey(), ProjectAction.toFileDataResponse(pathFileDataEntry.getValue()));
        }
        return response.build();
    }

    private static Map<String, Batch.WsProjectResponse.Settings> buildSettingsByModule(ProjectRepositories data) {
        HashMap<String, Batch.WsProjectResponse.Settings> settingsByModuleResponse = new HashMap<String, Batch.WsProjectResponse.Settings>();
        for (Map.Entry moduleSettingsEntry : data.settings().entrySet()) {
            settingsByModuleResponse.put((String)moduleSettingsEntry.getKey(), ProjectAction.toSettingsResponse((Map)moduleSettingsEntry.getValue()));
        }
        return settingsByModuleResponse;
    }

    private static Batch.WsProjectResponse.Settings toSettingsResponse(Map<String, String> settings) {
        Batch.WsProjectResponse.Settings.Builder settingsResponse = Batch.WsProjectResponse.Settings.newBuilder();
        settingsResponse.getMutableSettings().putAll(settings);
        return settingsResponse.build();
    }

    private static Batch.WsProjectResponse.FileData toFileDataResponse(FileData fileData) {
        Batch.WsProjectResponse.FileData.Builder fileDataBuilder = Batch.WsProjectResponse.FileData.newBuilder();
        Protobuf.setNullable((Object)fileData.hash(), arg_0 -> ((Batch.WsProjectResponse.FileData.Builder)fileDataBuilder).setHash(arg_0));
        Protobuf.setNullable((Object)fileData.revision(), arg_0 -> ((Batch.WsProjectResponse.FileData.Builder)fileDataBuilder).setRevision(arg_0));
        return fileDataBuilder.build();
    }
}

