/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication.event;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.server.authentication.event.AuthenticationEvent;

public class AuthenticationException
extends RuntimeException {
    private final AuthenticationEvent.Source source;
    @CheckForNull
    private final String login;
    private final String publicMessage;

    private AuthenticationException(Builder builder) {
        super(builder.message);
        this.source = Objects.requireNonNull(builder.source, "source can't be null");
        this.login = builder.login;
        this.publicMessage = builder.publicMessage;
    }

    public AuthenticationEvent.Source getSource() {
        return this.source;
    }

    @CheckForNull
    public String getLogin() {
        return this.login;
    }

    @CheckForNull
    public String getPublicMessage() {
        return this.publicMessage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        @CheckForNull
        private AuthenticationEvent.Source source;
        @CheckForNull
        private String login;
        @CheckForNull
        private String message;
        @CheckForNull
        private String publicMessage;

        private Builder() {
        }

        public Builder setSource(AuthenticationEvent.Source source) {
            this.source = source;
            return this;
        }

        public Builder setLogin(@Nullable String login) {
            this.login = login;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setPublicMessage(String publicMessage) {
            this.publicMessage = publicMessage;
            return this;
        }

        public AuthenticationException build() {
            return new AuthenticationException(this);
        }
    }
}

