/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication.event;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.OAuth2IdentityProvider;
import org.sonar.server.authentication.event.AuthenticationException;

public interface AuthenticationEvent {
    public void loginSuccess(HttpServletRequest var1, String var2, Source var3);

    public void loginFailure(HttpServletRequest var1, AuthenticationException var2);

    public void logoutSuccess(HttpServletRequest var1, @Nullable String var2);

    public void logoutFailure(HttpServletRequest var1, String var2);

    public static final class Source
    implements Serializable {
        private static final String LOCAL_PROVIDER_NAME = "local";
        private static final Source SSO_INSTANCE = new Source(Method.SSO, Provider.SSO, "sso");
        private static final Source JWT_INSTANCE = new Source(Method.JWT, Provider.JWT, "jwt");
        private final Method method;
        private final Provider provider;
        private final String providerName;

        private Source(Method method, Provider provider, String providerName) {
            this.method = Objects.requireNonNull(method, "method can't be null");
            this.provider = Objects.requireNonNull(provider, "provider can't be null");
            this.providerName = Objects.requireNonNull(providerName, "provider name can't be null");
            Preconditions.checkArgument((!providerName.isEmpty() ? 1 : 0) != 0, (Object)"provider name can't be empty");
        }

        public static Source local(Method method) {
            return new Source(method, Provider.LOCAL, LOCAL_PROVIDER_NAME);
        }

        public static Source oauth2(OAuth2IdentityProvider identityProvider) {
            return new Source(Method.OAUTH2, Provider.EXTERNAL, Objects.requireNonNull(identityProvider, "identityProvider can't be null").getName());
        }

        public static Source realm(Method method, String providerName) {
            return new Source(method, Provider.REALM, providerName);
        }

        public static Source sso() {
            return SSO_INSTANCE;
        }

        public static Source jwt() {
            return JWT_INSTANCE;
        }

        public static Source external(IdentityProvider identityProvider) {
            return new Source(Method.EXTERNAL, Provider.EXTERNAL, Objects.requireNonNull(identityProvider, "identityProvider can't be null").getName());
        }

        public Method getMethod() {
            return this.method;
        }

        public Provider getProvider() {
            return this.provider;
        }

        public String getProviderName() {
            return this.providerName;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Source source = (Source)o;
            return this.method == source.method && this.provider == source.provider && this.providerName.equals(source.providerName);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.method, this.provider, this.providerName});
        }

        public String toString() {
            return "Source{method=" + (Object)((Object)this.method) + ", provider=" + (Object)((Object)this.provider) + ", providerName='" + this.providerName + '\'' + '}';
        }
    }

    public static enum Provider {
        LOCAL,
        SSO,
        REALM,
        JWT,
        EXTERNAL;

    }

    public static enum Method {
        BASIC,
        BASIC_TOKEN,
        FORM,
        SSO,
        OAUTH2,
        JWT,
        EXTERNAL;

    }
}

