/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sonar.server.authentication.Cookies;
import org.sonar.server.authentication.OAuth2AuthenticationParameters;

public class OAuth2AuthenticationParametersImpl
implements OAuth2AuthenticationParameters {
    private static final String AUTHENTICATION_COOKIE_NAME = "AUTH-PARAMS";
    private static final int FIVE_MINUTES_IN_SECONDS = 300;
    private static final String RETURN_TO_PARAMETER = "return_to";
    private static final String ALLOW_EMAIL_SHIFT_PARAMETER = "allowEmailShift";
    private static final String ALLOW_LOGIN_UPDATE_PARAMETER = "allowUpdateLogin";
    private static final Type JSON_MAP_TYPE = new TypeToken<HashMap<String, String>>(){}.getType();

    @Override
    public void init(HttpServletRequest request, HttpServletResponse response) {
        String returnTo = request.getParameter(RETURN_TO_PARAMETER);
        String allowEmailShift = request.getParameter(ALLOW_EMAIL_SHIFT_PARAMETER);
        String allowLoginUpdate = request.getParameter(ALLOW_LOGIN_UPDATE_PARAMETER);
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)returnTo)) {
            parameters.put(RETURN_TO_PARAMETER, returnTo);
        }
        if (StringUtils.isNotBlank((String)allowEmailShift)) {
            parameters.put(ALLOW_EMAIL_SHIFT_PARAMETER, allowEmailShift);
        }
        if (StringUtils.isNotBlank((String)allowLoginUpdate)) {
            parameters.put(ALLOW_LOGIN_UPDATE_PARAMETER, allowLoginUpdate);
        }
        if (parameters.isEmpty()) {
            return;
        }
        response.addCookie(Cookies.newCookieBuilder(request).setName(AUTHENTICATION_COOKIE_NAME).setValue(OAuth2AuthenticationParametersImpl.toJson(parameters)).setHttpOnly(true).setExpiry(300).build());
    }

    @Override
    public Optional<String> getReturnTo(HttpServletRequest request) {
        return OAuth2AuthenticationParametersImpl.getParameter(request, RETURN_TO_PARAMETER);
    }

    @Override
    public Optional<Boolean> getAllowEmailShift(HttpServletRequest request) {
        Optional<String> parameter = OAuth2AuthenticationParametersImpl.getParameter(request, ALLOW_EMAIL_SHIFT_PARAMETER);
        return parameter.map(Boolean::parseBoolean);
    }

    @Override
    public Optional<Boolean> getAllowUpdateLogin(HttpServletRequest request) {
        Optional<String> parameter = OAuth2AuthenticationParametersImpl.getParameter(request, ALLOW_LOGIN_UPDATE_PARAMETER);
        return parameter.map(Boolean::parseBoolean);
    }

    private static Optional<String> getParameter(HttpServletRequest request, String parameterKey) {
        Optional<Cookie> cookie = Cookies.findCookie(AUTHENTICATION_COOKIE_NAME, request);
        if (!cookie.isPresent()) {
            return Optional.empty();
        }
        Map<String, String> parameters = OAuth2AuthenticationParametersImpl.fromJson(cookie.get().getValue());
        if (parameters.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(parameters.get(parameterKey));
    }

    @Override
    public void delete(HttpServletRequest request, HttpServletResponse response) {
        response.addCookie(Cookies.newCookieBuilder(request).setName(AUTHENTICATION_COOKIE_NAME).setValue(null).setHttpOnly(true).setExpiry(0).build());
    }

    private static String toJson(Map<String, String> map) {
        Gson gson = new GsonBuilder().create();
        try {
            return URLEncoder.encode(gson.toJson(map), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Map<String, String> fromJson(String json) {
        Gson gson = new GsonBuilder().create();
        try {
            return (Map)gson.fromJson(URLDecoder.decode(json, StandardCharsets.UTF_8.name()), JSON_MAP_TYPE);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

