/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.platform.Server;
import org.sonar.api.server.authentication.BaseIdentityProvider;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.OAuth2IdentityProvider;
import org.sonar.api.server.authentication.UnauthorizedException;
import org.sonar.api.web.ServletFilter;
import org.sonar.server.authentication.AuthenticationError;
import org.sonar.server.authentication.AuthenticationFilter;
import org.sonar.server.authentication.AuthenticationRedirection;
import org.sonar.server.authentication.BaseContextFactory;
import org.sonar.server.authentication.IdentityProviderRepository;
import org.sonar.server.authentication.OAuth2AuthenticationParameters;
import org.sonar.server.authentication.OAuth2ContextFactory;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;
import org.sonar.server.authentication.exception.RedirectionException;

public class InitFilter
extends AuthenticationFilter {
    private static final String INIT_CONTEXT = "/sessions/init/";
    private final BaseContextFactory baseContextFactory;
    private final OAuth2ContextFactory oAuth2ContextFactory;
    private final AuthenticationEvent authenticationEvent;
    private final OAuth2AuthenticationParameters oAuthOAuth2AuthenticationParameters;

    public InitFilter(IdentityProviderRepository identityProviderRepository, BaseContextFactory baseContextFactory, OAuth2ContextFactory oAuth2ContextFactory, Server server, AuthenticationEvent authenticationEvent, OAuth2AuthenticationParameters oAuthOAuth2AuthenticationParameters) {
        super(server, identityProviderRepository);
        this.baseContextFactory = baseContextFactory;
        this.oAuth2ContextFactory = oAuth2ContextFactory;
        this.authenticationEvent = authenticationEvent;
        this.oAuthOAuth2AuthenticationParameters = oAuthOAuth2AuthenticationParameters;
    }

    public ServletFilter.UrlPattern doGetPattern() {
        return ServletFilter.UrlPattern.create((String)"/sessions/init/*");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        IdentityProvider provider = this.resolveProviderOrHandleResponse(httpRequest, httpResponse, INIT_CONTEXT);
        if (provider != null) {
            this.handleProvider(httpRequest, httpResponse, provider);
        }
    }

    private void handleProvider(HttpServletRequest request, HttpServletResponse response, IdentityProvider provider) {
        try {
            if (provider instanceof BaseIdentityProvider) {
                this.handleBaseIdentityProvider(request, response, (BaseIdentityProvider)provider);
            } else if (provider instanceof OAuth2IdentityProvider) {
                this.oAuthOAuth2AuthenticationParameters.init(request, response);
                this.handleOAuth2IdentityProvider(request, response, (OAuth2IdentityProvider)provider);
            } else {
                AuthenticationError.handleError(response, String.format("Unsupported IdentityProvider class: %s", provider.getClass()));
            }
        }
        catch (AuthenticationException e) {
            this.oAuthOAuth2AuthenticationParameters.delete(request, response);
            this.authenticationEvent.loginFailure(request, e);
            AuthenticationError.handleAuthenticationError(e, response, this.getContextPath());
        }
        catch (RedirectionException e) {
            this.oAuthOAuth2AuthenticationParameters.delete(request, response);
            AuthenticationRedirection.redirectTo(response, e.getPath(this.getContextPath()));
        }
        catch (Exception e) {
            this.oAuthOAuth2AuthenticationParameters.delete(request, response);
            AuthenticationError.handleError(e, response, String.format("Fail to initialize authentication with provider '%s'", provider.getKey()));
        }
    }

    private void handleBaseIdentityProvider(HttpServletRequest request, HttpServletResponse response, BaseIdentityProvider provider) {
        try {
            provider.init(this.baseContextFactory.newContext(request, response, provider));
        }
        catch (UnauthorizedException e) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.external((IdentityProvider)provider)).setMessage(e.getMessage()).setPublicMessage(e.getMessage()).build();
        }
    }

    private void handleOAuth2IdentityProvider(HttpServletRequest request, HttpServletResponse response, OAuth2IdentityProvider provider) {
        try {
            provider.init(this.oAuth2ContextFactory.newContext(request, response, provider));
        }
        catch (UnauthorizedException e) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.oauth2(provider)).setMessage(e.getMessage()).setPublicMessage(e.getMessage()).build();
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

