/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.async.AsyncExecutionExecutorService;
import org.sonar.server.async.AsyncExecutionMonitoring;
import org.sonar.server.util.AbstractStoppableExecutorService;

public class AsyncExecutionExecutorServiceImpl
extends AbstractStoppableExecutorService<ThreadPoolExecutor>
implements AsyncExecutionExecutorService,
AsyncExecutionMonitoring {
    private static final Logger LOG = Loggers.get(AsyncExecutionExecutorServiceImpl.class);
    private static final int MAX_THREAD_COUNT = 10;
    private static final int UNLIMITED_QUEUE = Integer.MAX_VALUE;
    private static final long KEEP_ALIVE_TIME_IN_MINUTES = 5L;

    public AsyncExecutionExecutorServiceImpl() {
        super(AsyncExecutionExecutorServiceImpl.createDelegate());
    }

    private static ThreadPoolExecutor createDelegate() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(10, 10, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), new ThreadFactoryBuilder().setDaemon(false).setNameFormat("SQ_async-%d").setUncaughtExceptionHandler((t, e) -> LOG.error("Thread " + t + " failed unexpectedly", e)).build());
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return threadPoolExecutor;
    }

    @Override
    public void addToQueue(Runnable r) {
        this.submit(r);
    }

    @Override
    public int getQueueSize() {
        return ((ThreadPoolExecutor)this.delegate).getQueue().size();
    }

    @Override
    public int getWorkerCount() {
        return ((ThreadPoolExecutor)this.delegate).getPoolSize();
    }

    @Override
    public int getLargestWorkerCount() {
        return ((ThreadPoolExecutor)this.delegate).getLargestPoolSize();
    }
}

