/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.app;

import com.google.common.base.Throwables;
import java.io.File;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.FileUtils;
import org.sonar.process.ProcessProperties;
import org.sonar.process.Props;
import org.sonar.server.app.TomcatAccessLog;
import org.sonar.server.app.TomcatConnectors;
import org.sonar.server.app.TomcatContexts;
import org.sonar.server.app.TomcatStartupLogs;

class EmbeddedTomcat {
    private final Props props;
    private Tomcat tomcat = null;
    private volatile StandardContext webappContext;

    EmbeddedTomcat(Props props) {
        this.props = props;
    }

    void start() {
        System.setProperty("org.apache.tomcat.util.buf.UDecoder.ALLOW_ENCODED_SLASH", "true");
        System.setProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE", "true");
        this.tomcat = new Tomcat();
        String basedir = this.tomcatBasedir().getAbsolutePath();
        this.tomcat.setBaseDir(basedir);
        this.tomcat.getHost().setAppBase(basedir);
        this.tomcat.getHost().setAutoDeploy(false);
        this.tomcat.getHost().setCreateDirs(false);
        this.tomcat.getHost().setDeployOnStartup(true);
        new TomcatAccessLog().configure(this.tomcat, this.props);
        TomcatConnectors.configure(this.tomcat, this.props);
        this.webappContext = new TomcatContexts().configure(this.tomcat, this.props);
        try {
            this.tomcat.start();
            new TomcatStartupLogs(Loggers.get(this.getClass())).log(this.tomcat);
        }
        catch (LifecycleException e) {
            Loggers.get(EmbeddedTomcat.class).error("Fail to start web server", (Throwable)e);
            Throwables.propagate((Throwable)e);
        }
    }

    Status getStatus() {
        if (this.webappContext == null) {
            return Status.DOWN;
        }
        switch (this.webappContext.getState()) {
            case NEW: 
            case INITIALIZING: 
            case INITIALIZED: 
            case STARTING_PREP: 
            case STARTING: {
                return Status.DOWN;
            }
            case STARTED: {
                return Status.UP;
            }
        }
        return Status.FAILED;
    }

    private File tomcatBasedir() {
        return new File(this.props.value(ProcessProperties.Property.PATH_TEMP.getKey()), "tc");
    }

    void terminate() {
        if (this.tomcat.getServer().getState().isAvailable()) {
            try {
                this.tomcat.stop();
                this.tomcat.destroy();
            }
            catch (Exception e) {
                Loggers.get(EmbeddedTomcat.class).error("Fail to stop web server", (Throwable)e);
            }
        }
        FileUtils.deleteQuietly((File)this.tomcatBasedir());
    }

    void awaitTermination() {
        this.tomcat.getServer().await();
    }

    public static enum Status {
        DOWN,
        UP,
        FAILED;

    }
}

