/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.notification;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class ReportAnalysisFailureNotification {
    public static final String TYPE = "ce-report-task-failure";
    private final Project project;
    private final Task task;
    private final String errorMessage;

    public ReportAnalysisFailureNotification(Project project, Task task, @Nullable String errorMessage) {
        this.project = Objects.requireNonNull(project, "project can't be null");
        this.task = Objects.requireNonNull(task, "task can't be null");
        this.errorMessage = errorMessage;
    }

    public Project getProject() {
        return this.project;
    }

    public Task getTask() {
        return this.task;
    }

    @CheckForNull
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static final class Task {
        private final String uuid;
        private final long createdAt;
        private final long failedAt;

        public Task(String uuid, long createdAt, long failedAt) {
            this.uuid = Objects.requireNonNull(uuid, "uuid can't be null");
            this.createdAt = createdAt;
            this.failedAt = failedAt;
        }

        public String getUuid() {
            return this.uuid;
        }

        public long getCreatedAt() {
            return this.createdAt;
        }

        public long getFailedAt() {
            return this.failedAt;
        }
    }

    public static final class Project {
        private final String uuid;
        private final String key;
        private final String name;
        private final String branchName;

        public Project(String uuid, String key, String name, @Nullable String branchName) {
            this.uuid = Objects.requireNonNull(uuid, "uuid can't be null");
            this.key = Objects.requireNonNull(key, "key can't be null");
            this.name = Objects.requireNonNull(name, "name can't be null");
            this.branchName = branchName;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        @CheckForNull
        public String getBranchName() {
            return this.branchName;
        }
    }
}

