/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ws;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.web.ServletFilter;
import org.sonar.server.ws.ServletRequest;
import org.sonar.server.ws.ServletResponse;
import org.sonar.server.ws.WebServiceEngine;

public class DeprecatedPropertiesWsFilter
extends ServletFilter {
    private static final Splitter VALUE_SPLITTER = Splitter.on((String)",").omitEmptyStrings();
    private static final String SEPARATOR = "/";
    private final WebServiceEngine webServiceEngine;

    public DeprecatedPropertiesWsFilter(WebServiceEngine webServiceEngine) {
        this.webServiceEngine = webServiceEngine;
    }

    public ServletFilter.UrlPattern doGetPattern() {
        return ServletFilter.UrlPattern.builder().includes(new String[]{"/api/properties/*"}).build();
    }

    public void doFilter(javax.servlet.ServletRequest servletRequest, javax.servlet.ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        RestServletRequest wsRequest = new RestServletRequest(request);
        ServletResponse wsResponse = new ServletResponse(response);
        this.webServiceEngine.execute((Request)wsRequest, wsResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private static class Response {
        private final HttpServletRequest request;
        private final Map<String, String> additionalParams = new HashMap<String, String>();
        private final Multimap<String, String> additionalMultiParams = ArrayListMultimap.create();
        private final String originalPath;
        private String redirectedPath;
        private String redirectedMethod;

        Response(HttpServletRequest request) {
            this.request = request;
            this.originalPath = request.getRequestURI().replaceFirst(request.getContextPath(), "");
            this.init();
        }

        void init() {
            String method = this.request.getMethod();
            Optional<String> id = this.getKeyOrId();
            switch (method) {
                case "POST": 
                case "PUT": {
                    this.handlePutAndPost(id, this.getValues(), this.getComponent());
                    break;
                }
                case "DELETE": {
                    this.handleDelete(id, this.getComponent());
                    break;
                }
                default: {
                    this.handleGet(id, this.getComponent());
                }
            }
        }

        private void handlePutAndPost(Optional<String> key, List<String> values, Optional<String> component) {
            if (values.isEmpty()) {
                this.redirectToReset(key, component);
            } else {
                this.redirectToSet(key, values, component);
            }
        }

        private void handleDelete(Optional<String> key, Optional<String> component) {
            this.redirectToReset(key, component);
        }

        private void handleGet(Optional<String> key, Optional<String> component) {
            this.addParameterIfPresent("id", key);
            this.addParameterIfPresent("resource", component);
            this.addParameterIfPresent("format", this.readParam("format"));
            this.redirectedPath = "api/properties/index";
            this.redirectedMethod = "GET";
        }

        private Optional<String> getKeyOrId() {
            Optional<String> key = this.getKey();
            return key.isPresent() ? key : this.readParam("id");
        }

        private Optional<String> getKey() {
            if (this.originalPath.equals("/api/properties")) {
                return Optional.empty();
            }
            String key = this.originalPath.replace("/api/properties/", "");
            return key.isEmpty() ? Optional.empty() : Optional.of(key);
        }

        private Optional<String> getComponent() {
            return this.readParam("resource");
        }

        private List<String> getValues() {
            Optional<String> value = this.readParam("value");
            if (!value.isPresent()) {
                ArrayList<String> values = new ArrayList<String>();
                this.readBody().ifPresent(values::add);
                return values;
            }
            return VALUE_SPLITTER.splitToList((CharSequence)value.get());
        }

        private Optional<String> readParam(String paramKey) {
            String paramValue = this.request.getParameter(paramKey);
            return Strings.isNullOrEmpty((String)paramValue) ? Optional.empty() : Optional.of(paramValue);
        }

        private Optional<String> readBody() {
            StringWriter writer = new StringWriter();
            try {
                ServletInputStream inputStream = this.request.getInputStream();
                if (inputStream == null) {
                    return Optional.empty();
                }
                IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)StandardCharsets.UTF_8.name());
                return Optional.of(writer.toString());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        private void redirectToSet(Optional<String> key, List<String> values, Optional<String> component) {
            this.addParameterIfPresent("key", key);
            if (values.size() == 1) {
                this.additionalParams.put("value", values.get(0));
            } else {
                this.additionalMultiParams.putAll((Object)"values", values);
            }
            this.addParameterIfPresent("component", component);
            this.redirectedPath = "api/settings/set";
            this.redirectedMethod = "POST";
        }

        private void redirectToReset(Optional<String> key, Optional<String> component) {
            this.addParameterIfPresent("keys", key);
            this.addParameterIfPresent("component", component);
            this.redirectedPath = "api/settings/reset";
            this.redirectedMethod = "POST";
        }

        private void addParameterIfPresent(String parameterKey, Optional<String> value) {
            value.ifPresent(s -> this.additionalParams.put(parameterKey, (String)s));
        }
    }

    static class RestServletRequest
    extends ServletRequest {
        private final Response restResponse;

        RestServletRequest(HttpServletRequest request) {
            super(request);
            this.restResponse = new Response(request);
        }

        @Override
        public String getPath() {
            return this.restResponse.redirectedPath;
        }

        @Override
        public boolean hasParam(String key) {
            return this.restResponse.additionalParams.containsKey(key) || this.restResponse.additionalMultiParams.containsKey((Object)key);
        }

        @Override
        protected String readParam(String key) {
            return (String)this.restResponse.additionalParams.get(key);
        }

        @Override
        protected List<String> readMultiParam(String key) {
            return new ArrayList<String>(this.restResponse.additionalMultiParams.get((Object)key));
        }

        @Override
        public String method() {
            return this.restResponse.redirectedMethod;
        }
    }
}

