/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook.ws;

import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.Objects;
import java.util.Optional;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.webhook.WebhookDeliveryDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.user.UserSession;
import org.sonar.server.webhook.ws.WebhookWsSupport;
import org.sonar.server.webhook.ws.WebhooksWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Webhooks;

public class WebhookDeliveryAction
implements WebhooksWsAction {
    private static final String PARAM_ID = "deliveryId";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public WebhookDeliveryAction(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("delivery").setSince("6.2").setDescription("Get a webhook delivery by its id.<br/>Require 'Administer System' permission.<br/>Note that additional information are returned by api/webhooks/delivery.").setResponseExample(Resources.getResource(this.getClass(), (String)"example-delivery.json")).setHandler((RequestHandler)this);
        action.createParam(PARAM_ID).setDescription("Id of delivery").setRequired(true).setExampleValue((Object)"AU-TpxcA-iU5OvuD2FL3");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        Data data = this.loadFromDatabase(request.mandatoryParam(PARAM_ID));
        data.ensureAdminPermission(this.userSession);
        data.writeTo(request, response);
    }

    private Data loadFromDatabase(String deliveryUuid) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional delivery = this.dbClient.webhookDeliveryDao().selectByUuid(dbSession, deliveryUuid);
            WsUtils.checkFoundWithOptional(delivery, "Webhook delivery not found", new Object[0]);
            ComponentDto component = this.componentFinder.getByUuid(dbSession, ((WebhookDeliveryDto)delivery.get()).getComponentUuid());
            Data data = new Data(component, (WebhookDeliveryDto)delivery.get());
            return data;
        }
    }

    private static class Data {
        private final ComponentDto component;
        private final WebhookDeliveryDto deliveryDto;

        Data(ComponentDto component, WebhookDeliveryDto delivery) {
            this.deliveryDto = Objects.requireNonNull(delivery);
            this.component = Objects.requireNonNull(component);
        }

        void ensureAdminPermission(UserSession userSession) {
            userSession.checkComponentPermission("admin", this.component);
        }

        void writeTo(Request request, Response response) {
            Webhooks.DeliveryWsResponse.Builder responseBuilder = Webhooks.DeliveryWsResponse.newBuilder();
            Webhooks.Delivery.Builder deliveryBuilder = Webhooks.Delivery.newBuilder();
            WebhookWsSupport.copyDtoToProtobuf(this.component, this.deliveryDto, deliveryBuilder);
            responseBuilder.setDelivery(deliveryBuilder);
            WsUtils.writeProtobuf((Message)responseBuilder.build(), request, response);
        }
    }
}

