/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usertoken.ws;

import com.google.common.base.Optional;
import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.db.user.UserTokenDto;
import org.sonar.db.user.UserTokenValidator;
import org.sonar.server.exceptions.ServerException;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.usertoken.TokenGenerator;
import org.sonar.server.usertoken.ws.TokenPermissionsValidator;
import org.sonar.server.usertoken.ws.UserTokensWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsUserTokens;
import org.sonarqube.ws.client.usertoken.GenerateWsRequest;

public class GenerateAction
implements UserTokensWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final System2 system;
    private final TokenGenerator tokenGenerator;

    public GenerateAction(DbClient dbClient, UserSession userSession, System2 system, TokenGenerator tokenGenerator) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.system = system;
        this.tokenGenerator = tokenGenerator;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("generate").setSince("5.3").setPost(true).setDescription("Generate a user access token. <br />Please keep your tokens secret. They enable to authenticate and analyze projects.<br />If the login is set, it requires administration permissions. Otherwise, a token is generated for the authenticated user.").setResponseExample(this.getClass().getResource("generate-example.json")).setHandler((RequestHandler)this);
        action.createParam("login").setDescription("User login. If not set, the token is generated for the authenticated user.").setExampleValue((Object)"g.hopper");
        action.createParam("name").setRequired(true).setDescription("Token name").setExampleValue((Object)"Project scan on Travis");
    }

    public void handle(Request request, Response response) throws Exception {
        WsUserTokens.GenerateWsResponse generateWsResponse = this.doHandle(this.toCreateWsRequest(request));
        WsUtils.writeProtobuf((Message)generateWsResponse, request, response);
    }

    private WsUserTokens.GenerateWsResponse doHandle(GenerateWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.checkWsRequest(dbSession, request);
            TokenPermissionsValidator.validate(this.userSession, request.getLogin());
            String token = this.tokenGenerator.generate();
            String tokenHash = this.hashToken(dbSession, token);
            UserTokenDto userTokenDto = this.insertTokenInDb(dbSession, request, tokenHash);
            WsUserTokens.GenerateWsResponse generateWsResponse = GenerateAction.buildResponse(userTokenDto, token);
            return generateWsResponse;
        }
    }

    private String hashToken(DbSession dbSession, String token) {
        String tokenHash = this.tokenGenerator.hash(token);
        Optional userToken = this.dbClient.userTokenDao().selectByTokenHash(dbSession, tokenHash);
        if (userToken.isPresent()) {
            throw new ServerException(500, "Error while generating token. Please try again.");
        }
        return tokenHash;
    }

    private void checkWsRequest(DbSession dbSession, GenerateWsRequest request) {
        UserTokenValidator.checkTokenName((String)request.getName());
        this.checkLoginExists(dbSession, request);
        Optional userTokenDto = this.dbClient.userTokenDao().selectByLoginAndName(dbSession, request.getLogin(), request.getName());
        WsUtils.checkRequest(!userTokenDto.isPresent(), "A user token with login '%s' and name '%s' already exists", request.getLogin(), request.getName());
    }

    private void checkLoginExists(DbSession dbSession, GenerateWsRequest request) {
        UserDto user = this.dbClient.userDao().selectByLogin(dbSession, request.getLogin());
        if (user == null) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
    }

    private UserTokenDto insertTokenInDb(DbSession dbSession, GenerateWsRequest request, String tokenHash) {
        UserTokenDto userTokenDto = new UserTokenDto().setLogin(request.getLogin()).setName(request.getName()).setTokenHash(tokenHash).setCreatedAt(this.system.now());
        this.dbClient.userTokenDao().insert(dbSession, userTokenDto);
        dbSession.commit();
        return userTokenDto;
    }

    private GenerateWsRequest toCreateWsRequest(Request request) {
        GenerateWsRequest generateWsRequest = new GenerateWsRequest().setLogin(request.param("login")).setName(request.mandatoryParam("name").trim());
        if (generateWsRequest.getLogin() == null) {
            generateWsRequest.setLogin(this.userSession.getLogin());
        }
        WsUtils.checkRequest(!generateWsRequest.getName().isEmpty(), "The '%s' parameter must not be blank", "name");
        return generateWsRequest;
    }

    private static WsUserTokens.GenerateWsResponse buildResponse(UserTokenDto userTokenDto, String token) {
        return WsUserTokens.GenerateWsResponse.newBuilder().setLogin(userTokenDto.getLogin()).setName(userTokenDto.getName()).setToken(token).build();
    }
}

