/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usertoken;

import com.google.common.base.Optional;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserTokenDto;
import org.sonar.server.usertoken.TokenGenerator;

public class UserTokenAuthenticator {
    private final TokenGenerator tokenGenerator;
    private final DbClient dbClient;

    public UserTokenAuthenticator(TokenGenerator tokenGenerator, DbClient dbClient) {
        this.tokenGenerator = tokenGenerator;
        this.dbClient = dbClient;
    }

    public java.util.Optional<String> authenticate(String token) {
        String tokenHash = this.tokenGenerator.hash(token);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional userToken = this.dbClient.userTokenDao().selectByTokenHash(dbSession, tokenHash);
            if (userToken.isPresent()) {
                java.util.Optional<String> optional = java.util.Optional.of(((UserTokenDto)userToken.get()).getLogin());
                return optional;
            }
            java.util.Optional<String> optional = java.util.Optional.empty();
            return optional;
        }
    }
}

