/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usergroups.ws;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.user.GroupDto;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.usergroups.DefaultGroupFinder;
import org.sonar.server.usergroups.ws.GroupId;
import org.sonar.server.usergroups.ws.GroupIdOrAnyone;
import org.sonar.server.usergroups.ws.GroupWsRef;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsUserGroups;

public class GroupWsSupport {
    static final String PARAM_GROUP_ID = "id";
    static final String PARAM_ORGANIZATION_KEY = "organization";
    static final String PARAM_GROUP_NAME = "name";
    static final String PARAM_GROUP_DESCRIPTION = "description";
    static final String PARAM_LOGIN = "login";
    static final int DESCRIPTION_MAX_LENGTH = 200;
    private final DbClient dbClient;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final DefaultGroupFinder defaultGroupFinder;

    public GroupWsSupport(DbClient dbClient, DefaultOrganizationProvider defaultOrganizationProvider, DefaultGroupFinder defaultGroupFinder) {
        this.dbClient = dbClient;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.defaultGroupFinder = defaultGroupFinder;
    }

    public GroupId findGroup(DbSession dbSession, Request request) {
        return GroupId.from(this.findGroupDto(dbSession, request));
    }

    public GroupDto findGroupDto(DbSession dbSession, Request request) {
        Integer id = request.paramAsInt(PARAM_GROUP_ID);
        String organizationKey = request.param(PARAM_ORGANIZATION_KEY);
        String name = request.param(PARAM_GROUP_NAME);
        return this.findGroupDto(dbSession, GroupWsRef.create(id, organizationKey, name));
    }

    public GroupDto findGroupDto(DbSession dbSession, GroupWsRef ref) {
        if (ref.hasId()) {
            GroupDto group = this.dbClient.groupDao().selectById(dbSession, ref.getId());
            WsUtils.checkFound(group, "No group with id '%s'", ref.getId());
            return group;
        }
        OrganizationDto org = this.findOrganizationByKey(dbSession, ref.getOrganizationKey());
        Optional group = this.dbClient.groupDao().selectByName(dbSession, org.getUuid(), ref.getName());
        WsUtils.checkFoundWithOptional(group, "No group with name '%s' in organization '%s'", ref.getName(), org.getKey());
        return (GroupDto)group.get();
    }

    public GroupIdOrAnyone findGroupOrAnyone(DbSession dbSession, GroupWsRef ref) {
        if (ref.hasId()) {
            GroupDto group = this.dbClient.groupDao().selectById(dbSession, ref.getId());
            WsUtils.checkFound(group, "No group with id '%s'", ref.getId());
            return GroupIdOrAnyone.from(group);
        }
        OrganizationDto org = this.findOrganizationByKey(dbSession, ref.getOrganizationKey());
        if (ref.isAnyone()) {
            return GroupIdOrAnyone.forAnyone(org.getUuid());
        }
        Optional group = this.dbClient.groupDao().selectByName(dbSession, org.getUuid(), ref.getName());
        WsUtils.checkFoundWithOptional(group, "No group with name '%s' in organization '%s'", ref.getName(), org.getKey());
        return GroupIdOrAnyone.from((GroupDto)group.get());
    }

    public OrganizationDto findOrganizationByKey(DbSession dbSession, @Nullable String key) {
        String effectiveKey = key;
        if (effectiveKey == null) {
            effectiveKey = this.defaultOrganizationProvider.get().getKey();
        }
        Optional org = this.dbClient.organizationDao().selectByKey(dbSession, effectiveKey);
        WsUtils.checkFoundWithOptional(org, "No organization with key '%s'", key);
        return (OrganizationDto)org.get();
    }

    @CheckForNull
    String validateDescription(@Nullable String description) {
        Preconditions.checkArgument((description == null || description.length() <= 200 ? 1 : 0) != 0, (String)"Description cannot be longer than %s characters", (Object[])new Object[]{200});
        return description;
    }

    void checkNameDoesNotExist(DbSession dbSession, String organizationUuid, String name) {
        WsUtils.checkRequest(!this.dbClient.groupDao().selectByName(dbSession, organizationUuid, name).isPresent(), "Group '%s' already exists", name);
    }

    void checkGroupIsNotDefault(DbSession dbSession, GroupDto groupDto) {
        GroupDto defaultGroup = this.defaultGroupFinder.findDefaultGroup(dbSession, groupDto.getOrganizationUuid());
        Preconditions.checkArgument((!defaultGroup.getId().equals(groupDto.getId()) ? 1 : 0) != 0, (String)"Default group '%s' cannot be used to perform this action", (Object[])new Object[]{groupDto.getName()});
    }

    static WsUserGroups.Group.Builder toProtobuf(OrganizationDto organization, GroupDto group, int membersCount, boolean isDefault) {
        WsUserGroups.Group.Builder wsGroup = WsUserGroups.Group.newBuilder().setId((long)group.getId().intValue()).setOrganization(organization.getKey()).setName(group.getName()).setMembersCount(membersCount).setDefault(isDefault);
        Protobuf.setNullable((Object)group.getDescription(), arg_0 -> ((WsUserGroups.Group.Builder)wsGroup).setDescription(arg_0));
        return wsGroup;
    }

    static void defineGroupWsParameters(WebService.NewAction action) {
        GroupWsSupport.defineGroupIdWsParameter(action);
        GroupWsSupport.defineGroupNameWsParameter(action);
    }

    private static void defineGroupIdWsParameter(WebService.NewAction action) {
        action.createParam(PARAM_GROUP_ID).setDescription("Group id").setExampleValue((Object)"42");
    }

    private static void defineGroupNameWsParameter(WebService.NewAction action) {
        action.createParam(PARAM_ORGANIZATION_KEY).setDescription("Key of organization").setExampleValue((Object)"my-org").setInternal(true).setSince("6.2");
        action.createParam(PARAM_GROUP_NAME).setDescription("Group name").setExampleValue((Object)"sonar-administrators");
    }

    static WebService.NewParam defineLoginWsParameter(WebService.NewAction action) {
        return action.createParam(PARAM_LOGIN).setDescription("User login").setExampleValue((Object)"g.hopper");
    }
}

