/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usergroups.ws;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.security.DefaultGroups;
import org.sonar.server.ws.WsUtils;

@Immutable
public class GroupWsRef {
    private static final int NULL_ID = -1;
    private final int id;
    private final String organizationKey;
    private final String name;

    private GroupWsRef(int id, @Nullable String organizationKey, @Nullable String name) {
        this.id = id;
        this.organizationKey = organizationKey;
        this.name = name;
    }

    public boolean hasId() {
        return this.id != -1;
    }

    public int getId() {
        Preconditions.checkState((boolean)this.hasId(), (Object)"Id is not present. Please see hasId().");
        return this.id;
    }

    @CheckForNull
    public String getOrganizationKey() {
        Preconditions.checkState((!this.hasId() ? 1 : 0) != 0, (Object)"Organization is not present. Please see hasId().");
        return this.organizationKey;
    }

    public String getName() {
        Preconditions.checkState((!this.hasId() ? 1 : 0) != 0, (Object)"Name is not present. Please see hasId().");
        return this.name;
    }

    static GroupWsRef fromId(int id) {
        Preconditions.checkArgument((id > -1 ? 1 : 0) != 0, (String)"Group id must be positive: %s", (Object[])new Object[]{id});
        return new GroupWsRef(id, null, null);
    }

    static GroupWsRef fromName(@Nullable String organizationKey, String name) {
        return new GroupWsRef(-1, organizationKey, Objects.requireNonNull(name));
    }

    public static GroupWsRef create(@Nullable Integer id, @Nullable String organizationKey, @Nullable String name) {
        if (id != null) {
            WsUtils.checkRequest(organizationKey == null && name == null, "Either group id or couple organization/group name must be set", new Object[0]);
            return GroupWsRef.fromId(id);
        }
        WsUtils.checkRequest(name != null, "Group name or group id must be provided", new Object[0]);
        return GroupWsRef.fromName(organizationKey, name);
    }

    public boolean isAnyone() {
        return !this.hasId() && DefaultGroups.isAnyone((String)this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupWsRef that = (GroupWsRef)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.organizationKey != null ? !this.organizationKey.equals(that.organizationKey) : that.organizationKey != null) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.organizationKey != null ? this.organizationKey.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GroupWsRef{");
        sb.append("id=").append(this.id);
        sb.append(", organizationKey='").append(this.organizationKey).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

