/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user;

import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.ws.Request;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.user.SystemPasscode;

@ServerSide
public class SystemPasscodeImpl
implements SystemPasscode,
Startable {
    public static final String PASSCODE_HTTP_HEADER = "X-Sonar-Passcode";
    public static final String PASSCODE_CONF_PROPERTY = "sonar.web.systemPasscode";
    private final Configuration configuration;
    private String configuredPasscode;

    public SystemPasscodeImpl(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean isConfigured() {
        return this.configuredPasscode != null;
    }

    @Override
    public boolean isValid(Request request) {
        if (this.configuredPasscode == null) {
            return false;
        }
        return request.header(PASSCODE_HTTP_HEADER).map(s -> this.configuredPasscode.equals(s)).orElse(false);
    }

    public void start() {
        Optional<String> passcodeOpt = this.configuration.get(PASSCODE_CONF_PROPERTY).map(StringUtils::trimToNull);
        if (passcodeOpt.isPresent()) {
            this.logState("enabled");
            this.configuredPasscode = passcodeOpt.get();
        } else {
            this.logState("disabled");
            this.configuredPasscode = null;
        }
    }

    private void logState(String state) {
        Loggers.get(this.getClass()).info("System authentication by passcode is {}", (Object)state);
    }

    public void stop() {
    }
}

