/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user;

import javax.annotation.Nullable;
import org.sonar.api.database.model.User;
import org.sonar.api.security.UserFinder;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;

public class DeprecatedUserFinder
implements UserFinder {
    private final DbClient dbClient;

    public DeprecatedUserFinder(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public User findById(int id) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            User user = DeprecatedUserFinder.copy(this.dbClient.userDao().selectUserById(dbSession, id));
            return user;
        }
    }

    public User findByLogin(String login) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            User user = DeprecatedUserFinder.copy(this.dbClient.userDao().selectActiveUserByLogin(dbSession, login));
            return user;
        }
    }

    private static User copy(@Nullable UserDto dto) {
        if (dto != null) {
            User user = new User().setEmail(dto.getEmail()).setLogin(dto.getLogin()).setName(dto.getName());
            user.setId(dto.getId());
            return user;
        }
        return null;
    }
}

