/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.api.user.User;
import org.sonar.api.user.UserFinder;
import org.sonar.api.user.UserQuery;
import org.sonar.core.user.DefaultUser;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;

public class DefaultUserFinder
implements UserFinder {
    private final DbClient dbClient;

    public DefaultUserFinder(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    @CheckForNull
    public User findByLogin(String login) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto dto = this.dbClient.userDao().selectActiveUserByLogin(dbSession, login);
            DefaultUser defaultUser = dto != null ? dto.toUser() : null;
            return defaultUser;
        }
    }

    public List<User> findByLogins(List<String> logins) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List dtos = this.dbClient.userDao().selectByLogins(dbSession, logins);
            List<User> list = DefaultUserFinder.toUsers(dtos);
            return list;
        }
    }

    public List<User> find(UserQuery query) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List dtos = this.dbClient.userDao().selectUsers(dbSession, query);
            List<User> list = DefaultUserFinder.toUsers(dtos);
            return list;
        }
    }

    private static List<User> toUsers(Collection<UserDto> dtos) {
        ArrayList users = Lists.newArrayList();
        for (UserDto dto : dtos) {
            users.add(dto.toUser());
        }
        return users;
    }
}

