/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.sonar.core.permission.ProjectPermissions;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.exceptions.ForbiddenException;
import org.sonar.server.exceptions.UnauthorizedException;
import org.sonar.server.user.UserSession;

public abstract class AbstractUserSession
implements UserSession {
    private static final String INSUFFICIENT_PRIVILEGES_MESSAGE = "Insufficient privileges";
    private static final ForbiddenException INSUFFICIENT_PRIVILEGES_EXCEPTION = new ForbiddenException("Insufficient privileges");
    private static final String AUTHENTICATION_IS_REQUIRED_MESSAGE = "Authentication is required";

    @Override
    public UserSession checkIsRoot() {
        if (!this.isRoot()) {
            throw new ForbiddenException(INSUFFICIENT_PRIVILEGES_MESSAGE);
        }
        return this;
    }

    @Override
    public final UserSession checkLoggedIn() {
        if (!this.isLoggedIn()) {
            throw new UnauthorizedException(AUTHENTICATION_IS_REQUIRED_MESSAGE);
        }
        return this;
    }

    @Override
    public final boolean hasPermission(OrganizationPermission permission, OrganizationDto organization) {
        return this.hasPermission(permission, organization.getUuid());
    }

    @Override
    public final boolean hasPermission(OrganizationPermission permission, String organizationUuid) {
        return this.isRoot() || this.hasPermissionImpl(permission, organizationUuid);
    }

    @Override
    public final UserSession checkPermission(OrganizationPermission permission, OrganizationDto organization) {
        return this.checkPermission(permission, organization.getUuid());
    }

    @Override
    public final UserSession checkPermission(OrganizationPermission permission, String organizationUuid) {
        if (!this.hasPermission(permission, organizationUuid)) {
            throw new ForbiddenException(INSUFFICIENT_PRIVILEGES_MESSAGE);
        }
        return this;
    }

    protected abstract boolean hasPermissionImpl(OrganizationPermission var1, String var2);

    @Override
    public final boolean hasComponentPermission(String permission, ComponentDto component) {
        if (this.isRoot()) {
            return true;
        }
        String projectUuid = StringUtils.defaultString((String)component.getMainBranchProjectUuid(), (String)component.projectUuid());
        return this.hasProjectUuidPermission(permission, projectUuid);
    }

    @Override
    public final boolean hasComponentUuidPermission(String permission, String componentUuid) {
        if (this.isRoot()) {
            return true;
        }
        Optional<String> projectUuid = this.componentUuidToProjectUuid(componentUuid);
        return projectUuid.map(s -> this.hasProjectUuidPermission(permission, (String)s)).orElse(false);
    }

    protected abstract Optional<String> componentUuidToProjectUuid(String var1);

    protected abstract boolean hasProjectUuidPermission(String var1, String var2);

    @Override
    public final UserSession checkComponentPermission(String projectPermission, ComponentDto component) {
        if (!this.hasComponentPermission(projectPermission, component)) {
            throw new ForbiddenException(INSUFFICIENT_PRIVILEGES_MESSAGE);
        }
        return this;
    }

    @Override
    public final UserSession checkComponentUuidPermission(String permission, String componentUuid) {
        if (!this.hasComponentUuidPermission(permission, componentUuid)) {
            throw new ForbiddenException(INSUFFICIENT_PRIVILEGES_MESSAGE);
        }
        return this;
    }

    public static ForbiddenException insufficientPrivilegesException() {
        return INSUFFICIENT_PRIVILEGES_EXCEPTION;
    }

    @Override
    public final List<ComponentDto> keepAuthorizedComponents(String permission, Collection<ComponentDto> components) {
        if (this.isRoot()) {
            return new ArrayList<ComponentDto>(components);
        }
        return this.doKeepAuthorizedComponents(permission, components);
    }

    protected List<ComponentDto> doKeepAuthorizedComponents(String permission, Collection<ComponentDto> components) {
        boolean allowPublicComponent = ProjectPermissions.PUBLIC_PERMISSIONS.contains(permission);
        return (List)components.stream().filter(c -> allowPublicComponent && !c.isPrivate() || this.hasComponentPermission(permission, (ComponentDto)c)).collect(MoreCollectors.toList());
    }

    @Override
    public final UserSession checkIsSystemAdministrator() {
        if (!this.isSystemAdministrator()) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
        return this;
    }
}

