/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.updatecenter.ws;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.IOUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.platform.ServerFileSystem;
import org.sonar.server.updatecenter.ws.UpdateCenterWsAction;
import org.sonar.server.user.UserSession;

public class UploadAction
implements UpdateCenterWsAction {
    public static final String PARAM_FILE = "file";
    private final UserSession userSession;
    private final File downloadDir;

    public UploadAction(UserSession userSession, ServerFileSystem fileSystem) {
        this.userSession = userSession;
        this.downloadDir = fileSystem.getDownloadedPluginsDir();
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("upload").setDescription("Upload a plugin.<br /> Requires 'Administer System' permission.").setSince("6.0").setPost(true).setInternal(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_FILE).setDescription("The jar file of the plugin to install").setRequired(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        Request.Part part = request.mandatoryParamAsPart(PARAM_FILE);
        String fileName = part.getFileName();
        Preconditions.checkArgument((boolean)fileName.endsWith(".jar"), (Object)"Only jar file is allowed");
        InputStream inputStream = part.getInputStream();
        try {
            File destPlugin = new File(this.downloadDir, fileName);
            Files.copy(inputStream, destPlugin.toPath(), StandardCopyOption.REPLACE_EXISTING);
            response.noContent();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

