/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.test.index;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.es.EsQueueDto;
import org.sonar.server.es.BulkIndexer;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.IndexingResult;
import org.sonar.server.es.OneToManyResilientIndexingListener;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.source.index.FileSourcesUpdaterHelper;
import org.sonar.server.test.index.TestIndexDefinition;
import org.sonar.server.test.index.TestResultSetIterator;

public class TestIndexer
implements ProjectIndexer {
    private final DbClient dbClient;
    private final EsClient esClient;

    public TestIndexer(DbClient dbClient, EsClient esClient) {
        this.dbClient = dbClient;
        this.esClient = esClient;
    }

    @Override
    public Set<IndexType> getIndexTypes() {
        return ImmutableSet.of((Object)TestIndexDefinition.INDEX_TYPE_TEST);
    }

    @Override
    public void indexOnStartup(Set<IndexType> uninitializedIndexTypes) {
        try (DbSession dbSession = this.dbClient.openSession(false);
             TestResultSetIterator rowIt = TestResultSetIterator.create(this.dbClient, dbSession, null);){
            BulkIndexer bulkIndexer = new BulkIndexer(this.esClient, TestIndexDefinition.INDEX_TYPE_TEST, BulkIndexer.Size.LARGE);
            bulkIndexer.start();
            TestIndexer.addTestsToBulkIndexer(rowIt, bulkIndexer);
            bulkIndexer.stop();
        }
    }

    @Override
    public void indexOnAnalysis(String branchUuid) {
        BulkIndexer bulkIndexer = new BulkIndexer(this.esClient, TestIndexDefinition.INDEX_TYPE_TEST, BulkIndexer.Size.REGULAR);
        bulkIndexer.start();
        this.addProjectDeletionToBulkIndexer(bulkIndexer, branchUuid);
        try (DbSession dbSession = this.dbClient.openSession(false);
             TestResultSetIterator rowIt = TestResultSetIterator.create(this.dbClient, dbSession, branchUuid);){
            TestIndexer.addTestsToBulkIndexer(rowIt, bulkIndexer);
        }
        bulkIndexer.stop();
    }

    @Override
    public Collection<EsQueueDto> prepareForRecovery(DbSession dbSession, Collection<String> projectUuids, ProjectIndexer.Cause cause) {
        switch (cause) {
            case PROJECT_CREATION: {
                return Collections.emptyList();
            }
            case PROJECT_KEY_UPDATE: 
            case PROJECT_TAGS_UPDATE: 
            case PERMISSION_CHANGE: {
                return Collections.emptyList();
            }
            case PROJECT_DELETION: {
                List items = (List)projectUuids.stream().map(projectUuid -> EsQueueDto.create((String)TestIndexDefinition.INDEX_TYPE_TEST.format(), (String)projectUuid, null, (String)projectUuid)).collect(MoreCollectors.toArrayList((int)projectUuids.size()));
                return this.dbClient.esQueueDao().insert(dbSession, (Collection)items);
            }
        }
        throw new IllegalStateException("Unsupported cause: " + (Object)((Object)cause));
    }

    public void deleteByFile(String fileUuid) {
        SearchRequestBuilder searchRequest = this.esClient.prepareSearch(TestIndexDefinition.INDEX_TYPE_TEST).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"fileUuid", (String)fileUuid));
        BulkIndexer.delete(this.esClient, TestIndexDefinition.INDEX_TYPE_TEST, searchRequest);
    }

    @Override
    public IndexingResult index(DbSession dbSession, Collection<EsQueueDto> items) {
        if (items.isEmpty()) {
            return new IndexingResult();
        }
        OneToManyResilientIndexingListener listener = new OneToManyResilientIndexingListener(this.dbClient, dbSession, items);
        BulkIndexer bulkIndexer = new BulkIndexer(this.esClient, TestIndexDefinition.INDEX_TYPE_TEST, BulkIndexer.Size.REGULAR, listener);
        bulkIndexer.start();
        items.forEach(i -> {
            String projectUuid = i.getDocId();
            this.addProjectDeletionToBulkIndexer(bulkIndexer, projectUuid);
        });
        return bulkIndexer.stop();
    }

    private void addProjectDeletionToBulkIndexer(BulkIndexer bulkIndexer, String projectUuid) {
        SearchRequestBuilder searchRequest = this.esClient.prepareSearch(TestIndexDefinition.INDEX_TYPE_TEST).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"projectUuid", (String)projectUuid));
        bulkIndexer.addDeletion(searchRequest);
    }

    private static void addTestsToBulkIndexer(TestResultSetIterator rowIt, BulkIndexer bulkIndexer) {
        while (rowIt.hasNext()) {
            FileSourcesUpdaterHelper.Row row = (FileSourcesUpdaterHelper.Row)rowIt.next();
            row.getUpdateRequests().forEach(bulkIndexer::add);
        }
    }
}

