/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.startup;

import org.picocontainer.Startable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.loadedtemplate.LoadedTemplateDto;

public class DisplayLogOnDeprecatedProjects
implements Startable {
    private static final Logger LOG = Loggers.get(DisplayLogOnDeprecatedProjects.class);
    private static final String TEMPLATE_KEY = "DisplayLogOnDeprecatedProjects";
    private final DbClient dbClient;

    public DisplayLogOnDeprecatedProjects(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public void start() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            if (!this.hasAlreadyBeenExecuted(dbSession)) {
                return;
            }
            this.displayLogOnDeprecatedProjectKeys(dbSession);
            this.registerTasks(dbSession);
            dbSession.commit();
        }
    }

    private void displayLogOnDeprecatedProjectKeys(DbSession session) {
        boolean hasDetectDeprecatedProjects = false;
        for (ComponentDto project : this.dbClient.componentDao().selectProjects(session)) {
            if (project.deprecatedKey() != null) continue;
            if (!hasDetectDeprecatedProjects) {
                LOG.warn("We detected that the following projects have not been analysed on a SonarQube version greater than 4.2 (included):");
                hasDetectDeprecatedProjects = true;
            }
            LOG.warn(" - {}", (Object)project.getDbKey());
        }
        if (hasDetectDeprecatedProjects) {
            LOG.warn("As a consequence, some features of the Web UI will be broken for them, and any new analysis will consider all issues as new issues.");
        }
    }

    private boolean hasAlreadyBeenExecuted(DbSession session) {
        return this.dbClient.loadedTemplateDao().countByTypeAndKey("ONE_SHOT_TASK", TEMPLATE_KEY, session) == 0;
    }

    private void registerTasks(DbSession session) {
        this.dbClient.loadedTemplateDao().insert(new LoadedTemplateDto(TEMPLATE_KEY, "ONE_SHOT_TASK"), session);
    }

    public void stop() {
    }
}

