/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;

class CharactersReader {
    static final int END_OF_STREAM = -1;
    private final BufferedReader stringBuffer;
    private final Deque<String> openTags;
    private int currentValue;
    private int previousValue;
    private int currentIndex = -1;

    public CharactersReader(BufferedReader stringBuffer) {
        this.stringBuffer = stringBuffer;
        this.openTags = new ArrayDeque<String>();
    }

    boolean readNextChar() throws IOException {
        this.previousValue = this.currentValue;
        this.currentValue = this.stringBuffer.read();
        ++this.currentIndex;
        return this.currentValue != -1;
    }

    int getCurrentValue() {
        return this.currentValue;
    }

    int getPreviousValue() {
        return this.previousValue;
    }

    int getCurrentIndex() {
        return this.currentIndex;
    }

    void registerOpenTag(String textType) {
        this.openTags.push(textType);
    }

    void removeLastOpenTag() {
        this.openTags.remove();
    }

    Deque<String> getOpenTags() {
        return this.openTags;
    }
}

