/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import com.google.common.base.Strings;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.server.rule.NewCustomRule;
import org.sonar.server.rule.ReactivationException;
import org.sonar.server.rule.RuleCreator;
import org.sonar.server.rule.ws.RuleMapper;
import org.sonar.server.rule.ws.RuleWsSupport;
import org.sonar.server.rule.ws.RulesWsAction;
import org.sonar.server.rule.ws.SearchAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Rules;

public class CreateAction
implements RulesWsAction {
    public static final String PARAM_CUSTOM_KEY = "custom_key";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_DESCRIPTION = "markdown_description";
    public static final String PARAM_SEVERITY = "severity";
    public static final String PARAM_STATUS = "status";
    public static final String PARAM_TEMPLATE_KEY = "template_key";
    public static final String PARAM_TYPE = "type";
    public static final String PARAMS = "params";
    public static final String PARAM_PREVENT_REACTIVATION = "prevent_reactivation";
    private final DbClient dbClient;
    private final RuleCreator ruleCreator;
    private final RuleMapper ruleMapper;
    private final RuleWsSupport ruleWsSupport;

    public CreateAction(DbClient dbClient, RuleCreator ruleCreator, RuleMapper ruleMapper, RuleWsSupport ruleWsSupport) {
        this.dbClient = dbClient;
        this.ruleCreator = ruleCreator;
        this.ruleMapper = ruleMapper;
        this.ruleWsSupport = ruleWsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("create").setDescription("Create a custom rule.<br>Requires the 'Administer Quality Profiles' permission").setSince("4.4").setChangelog(new Change[]{new Change("5.5", "Creating manual rule is not more possible")}).setPost(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_CUSTOM_KEY).setDescription("Key of the custom rule").setExampleValue((Object)"Todo_should_not_be_used").setRequired(true);
        action.createParam("manual_key").setDescription("Manual rules are no more supported. This parameter is ignored").setExampleValue((Object)"Error_handling").setDeprecatedSince("5.5");
        action.createParam(PARAM_TEMPLATE_KEY).setDescription("Key of the template rule in order to create a custom rule (mandatory for custom rule)").setExampleValue((Object)"java:XPath");
        action.createParam(PARAM_NAME).setDescription("Rule name").setRequired(true).setExampleValue((Object)"My custom rule");
        action.createParam(PARAM_DESCRIPTION).setDescription("Rule description").setRequired(true).setExampleValue((Object)"Description of my custom rule");
        action.createParam(PARAM_SEVERITY).setDescription("Rule severity").setPossibleValues((Collection)Severity.ALL);
        action.createParam(PARAM_STATUS).setDescription("Rule status").setDefaultValue((Object)RuleStatus.READY).setPossibleValues((Object[])RuleStatus.values());
        action.createParam(PARAMS).setDescription("Parameters as semi-colon list of <key>=<value>, for example 'params=key1=v1;key2=v2' (Only for custom rule)");
        action.createParam(PARAM_PREVENT_REACTIVATION).setDescription("If set to true and if the rule has been deactivated (status 'REMOVED'), a status 409 will be returned").setDefaultValue((Object)false).setBooleanPossibleValues();
        action.createParam(PARAM_TYPE).setDescription("Rule type").setSince("6.7").setPossibleValues((Collection)RuleType.names());
    }

    public void handle(Request request, Response response) throws Exception {
        this.ruleWsSupport.checkQProfileAdminPermissionOnDefaultOrganization();
        String customKey = request.mandatoryParam(PARAM_CUSTOM_KEY);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            try {
                NewCustomRule newRule = NewCustomRule.createForCustomRule(customKey, RuleKey.parse((String)request.mandatoryParam(PARAM_TEMPLATE_KEY))).setName(request.mandatoryParam(PARAM_NAME)).setMarkdownDescription(request.mandatoryParam(PARAM_DESCRIPTION)).setSeverity(request.mandatoryParam(PARAM_SEVERITY)).setStatus(RuleStatus.valueOf((String)request.mandatoryParam(PARAM_STATUS))).setPreventReactivation(request.mandatoryParamAsBoolean(PARAM_PREVENT_REACTIVATION));
                String params = request.param(PARAMS);
                if (!Strings.isNullOrEmpty((String)params)) {
                    newRule.setParameters(KeyValueFormat.parse((String)params));
                }
                Protobuf.setNullable((Object)request.param(PARAM_TYPE), t -> newRule.setType(RuleType.valueOf((String)t)));
                this.writeResponse(dbSession, request, response, this.ruleCreator.create(dbSession, newRule));
            }
            catch (ReactivationException e) {
                response.stream().setStatus(409);
                this.writeResponse(dbSession, request, response, e.ruleKey());
            }
        }
    }

    private void writeResponse(DbSession dbSession, Request request, Response response, RuleKey ruleKey) {
        WsUtils.writeProtobuf((Message)this.createResponse(dbSession, ruleKey), request, response);
    }

    private Rules.CreateResponse createResponse(DbSession dbSession, RuleKey ruleKey) {
        RuleDefinitionDto rule = (RuleDefinitionDto)this.dbClient.ruleDao().selectDefinitionByKey(dbSession, ruleKey).orElseThrow(() -> new IllegalStateException(String.format("Cannot load rule, that has just been created '%s'", ruleKey)));
        ArrayList<RuleDefinitionDto> templateRules = new ArrayList<RuleDefinitionDto>();
        if (rule.isCustomRule()) {
            Optional templateRule = this.dbClient.ruleDao().selectDefinitionById((long)rule.getTemplateId().intValue(), dbSession);
            templateRule.ifPresent(templateRules::add);
        }
        List ruleParameters = this.dbClient.ruleDao().selectRuleParamsByRuleIds(dbSession, Collections.singletonList(rule.getId()));
        SearchAction.SearchResult searchResult = new SearchAction.SearchResult().setRuleParameters(ruleParameters).setTemplateRules(templateRules).setTotal(1L);
        return Rules.CreateResponse.newBuilder().setRule(this.ruleMapper.toWsRule(rule, searchResult, Collections.emptySet())).build();
    }
}

