/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.index;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.rule.index.RuleIndexDefinition;

public class RuleQuery {
    private String key;
    private String queryText;
    private Collection<String> languages;
    private Collection<String> repositories;
    private Collection<String> severities;
    private Collection<RuleStatus> statuses;
    private Collection<String> tags;
    private Collection<RuleType> types;
    private Boolean activation;
    private QProfileDto profile;
    private QProfileDto compareToQProfile;
    private Collection<String> inheritance;
    private Collection<String> activeSeverities;
    private String templateKey;
    private Boolean isTemplate;
    private Long availableSince;
    private String sortField;
    private boolean ascendingSort = true;
    private String internalKey;
    private String ruleKey;
    private OrganizationDto organization;

    @CheckForNull
    public QProfileDto getQProfile() {
        return this.profile;
    }

    public RuleQuery setQProfile(@Nullable QProfileDto p) {
        this.profile = p;
        return this;
    }

    public RuleQuery setActivation(@Nullable Boolean activation) {
        this.activation = activation;
        return this;
    }

    @CheckForNull
    public Boolean getActivation() {
        return this.activation;
    }

    @CheckForNull
    public String getKey() {
        return this.key;
    }

    public RuleQuery setKey(@Nullable String key) {
        this.key = key;
        return this;
    }

    @CheckForNull
    public String getQueryText() {
        return this.queryText;
    }

    public RuleQuery setQueryText(@Nullable String queryText) {
        this.queryText = queryText;
        return this;
    }

    @CheckForNull
    public Collection<String> getLanguages() {
        return this.languages;
    }

    public RuleQuery setLanguages(@Nullable Collection<String> languages) {
        this.languages = languages;
        return this;
    }

    @CheckForNull
    public Collection<String> getRepositories() {
        return this.repositories;
    }

    public RuleQuery setRepositories(@Nullable Collection<String> repositories) {
        this.repositories = repositories;
        return this;
    }

    @CheckForNull
    public Collection<String> getSeverities() {
        return this.severities;
    }

    public RuleQuery setSeverities(@Nullable Collection<String> severities) {
        if (severities != null) {
            for (String severity : severities) {
                Preconditions.checkArgument((boolean)Severity.ALL.contains(severity), (Object)("Unknown severity: " + severity));
            }
        }
        this.severities = severities;
        return this;
    }

    public RuleQuery setSeverities(String ... severities) {
        if (severities != null) {
            return this.setSeverities(Arrays.asList(severities));
        }
        return this;
    }

    @CheckForNull
    public Collection<RuleStatus> getStatuses() {
        return this.statuses;
    }

    public RuleQuery setStatuses(@Nullable Collection<RuleStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    @CheckForNull
    public Collection<String> getTags() {
        return this.tags;
    }

    public RuleQuery setTags(@Nullable Collection<String> tags) {
        this.tags = tags;
        return this;
    }

    @CheckForNull
    public Collection<RuleType> getTypes() {
        return this.types;
    }

    public RuleQuery setTypes(@Nullable Collection<RuleType> types) {
        this.types = types;
        return this;
    }

    @CheckForNull
    public Collection<String> getInheritance() {
        return this.inheritance;
    }

    public RuleQuery setInheritance(@Nullable Collection<String> inheritance) {
        this.inheritance = inheritance;
        return this;
    }

    @CheckForNull
    public Collection<String> getActiveSeverities() {
        return this.activeSeverities;
    }

    public RuleQuery setActiveSeverities(@Nullable Collection<String> severities) {
        if (severities != null) {
            for (String severity : severities) {
                Preconditions.checkArgument((boolean)Severity.ALL.contains(severity), (Object)("Unknown severity: " + severity));
            }
        }
        this.activeSeverities = severities;
        return this;
    }

    @CheckForNull
    public Boolean isTemplate() {
        return this.isTemplate;
    }

    public RuleQuery setIsTemplate(@Nullable Boolean b) {
        this.isTemplate = b;
        return this;
    }

    @CheckForNull
    public String templateKey() {
        return this.templateKey;
    }

    public RuleQuery setTemplateKey(@Nullable String templateKey) {
        this.templateKey = templateKey;
        return this;
    }

    public String getSortField() {
        return this.sortField;
    }

    public RuleQuery setSortField(@Nullable String field) {
        if (field != null && !RuleIndexDefinition.SORT_FIELDS.contains(field)) {
            throw new IllegalStateException(String.format("Field '%s' is not sortable", field));
        }
        this.sortField = field;
        return this;
    }

    public boolean isAscendingSort() {
        return this.ascendingSort;
    }

    public RuleQuery setAscendingSort(boolean b) {
        this.ascendingSort = b;
        return this;
    }

    public RuleQuery setAvailableSince(@Nullable Long l) {
        this.availableSince = l;
        return this;
    }

    public Long getAvailableSinceLong() {
        return this.availableSince;
    }

    public RuleQuery setInternalKey(@Nullable String s) {
        this.internalKey = s;
        return this;
    }

    @CheckForNull
    public String getInternalKey() {
        return this.internalKey;
    }

    public RuleQuery setRuleKey(@Nullable String s) {
        this.ruleKey = s;
        return this;
    }

    @CheckForNull
    public String getRuleKey() {
        return this.ruleKey;
    }

    public OrganizationDto getOrganization() {
        return this.organization;
    }

    public RuleQuery setOrganization(OrganizationDto o) {
        this.organization = o;
        return this;
    }

    @CheckForNull
    public QProfileDto getCompareToQProfile() {
        return this.compareToQProfile;
    }

    public RuleQuery setCompareToQProfile(@Nullable QProfileDto compareToQProfile) {
        this.compareToQProfile = compareToQProfile;
        return this;
    }
}

