/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.resources.Languages;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.QProfileChangeDto;
import org.sonar.db.qualityprofile.QProfileChangeQuery;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.qualityprofile.ws.QProfileReference;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;

public class ChangelogAction
implements QProfileWsAction {
    private final QProfileWsSupport wsSupport;
    private final Languages languages;
    private DbClient dbClient;

    public ChangelogAction(QProfileWsSupport wsSupport, Languages languages, DbClient dbClient) {
        this.wsSupport = wsSupport;
        this.languages = languages;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction wsAction = context.createAction("changelog").setSince("5.2").setDescription("Get the history of changes on a quality profile: rule activation/deactivation, change in parameters/severity. Events are ordered by date in descending order (most recent first).").setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("changelog-example.json"));
        QProfileWsSupport.createOrganizationParam(wsAction).setSince("6.4");
        QProfileReference.defineParams(wsAction, this.languages);
        wsAction.addPagingParams(50, 500);
        wsAction.createParam("since").setDescription("Start date for the changelog. <br>Either a date (server timezone) or datetime can be provided.").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
        wsAction.createParam("to").setDescription("End date for the changelog. <br>Either a date (server timezone) or datetime can be provided.").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
    }

    public void handle(Request request, Response response) throws Exception {
        QProfileReference reference = QProfileReference.from(request);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Date to;
            QProfileDto profile = this.wsSupport.getProfile(dbSession, reference);
            QProfileChangeQuery query = new QProfileChangeQuery(profile.getKee());
            Date since = DateUtils.parseStartingDateOrDateTime((String)request.param("since"));
            if (since != null) {
                query.setFromIncluded(Long.valueOf(since.getTime()));
            }
            if ((to = DateUtils.parseEndingDateOrDateTime((String)request.param("to"))) != null) {
                query.setToExcluded(Long.valueOf(to.getTime()));
            }
            int page = request.mandatoryParamAsInt("p");
            int pageSize = request.mandatoryParamAsInt("ps");
            query.setPage(page, pageSize);
            int total = this.dbClient.qProfileChangeDao().countByQuery(dbSession, query);
            List<Change> changelogs = this.load(dbSession, query);
            ChangelogAction.writeResponse(response.newJsonWriter(), total, page, pageSize, changelogs);
        }
    }

    private static void writeResponse(JsonWriter json, int total, int page, int pageSize, List<Change> changelogs) {
        json.beginObject();
        json.prop("total", (long)total);
        json.prop("p", (long)page);
        json.prop("ps", (long)pageSize);
        json.name("events").beginArray();
        for (Change change : changelogs) {
            json.beginObject().prop("date", DateUtils.formatDateTime((long)change.getCreatedAt())).prop("authorLogin", change.getUserLogin()).prop("authorName", change.getUserName()).prop("action", change.getType()).prop("ruleKey", change.getRuleKey() == null ? null : change.getRuleKey().toString()).prop("ruleName", change.getRuleName());
            ChangelogAction.writeParameters(json, change);
            json.endObject();
        }
        json.endArray();
        json.endObject().close();
    }

    private static void writeParameters(JsonWriter json, Change change) {
        json.name("params").beginObject().prop("severity", change.getSeverity());
        for (Map.Entry<String, String> param : change.getParams().entrySet()) {
            json.prop(param.getKey(), param.getValue());
        }
        json.endObject();
    }

    public List<Change> load(DbSession dbSession, QProfileChangeQuery query) {
        List dtos = this.dbClient.qProfileChangeDao().selectByQuery(dbSession, query);
        List changes = (List)dtos.stream().map(x$0 -> Change.from(x$0)).collect(MoreCollectors.toList((int)dtos.size()));
        this.completeUserAndRuleNames(dbSession, changes);
        return changes;
    }

    private void completeUserAndRuleNames(DbSession dbSession, List<Change> changes) {
        Set logins = (Set)changes.stream().filter(c -> ((Change)c).userLogin != null).map(c -> ((Change)c).userLogin).collect(MoreCollectors.toSet());
        Map<String, String> userNamesByLogins = this.dbClient.userDao().selectByLogins(dbSession, (Collection)logins).stream().collect(Collectors.toMap(UserDto::getLogin, UserDto::getName));
        Set ruleKeys = (Set)changes.stream().filter(c -> ((Change)c).ruleKey != null).map(c -> ((Change)c).ruleKey).collect(MoreCollectors.toSet());
        Map<RuleKey, String> ruleNamesByKeys = this.dbClient.ruleDao().selectDefinitionByKeys(dbSession, (Collection)Lists.newArrayList((Iterable)ruleKeys)).stream().collect(Collectors.toMap(RuleDefinitionDto::getKey, RuleDefinitionDto::getName));
        changes.forEach(c -> {
            ((Change)c).userName = (String)userNamesByLogins.get(((Change)c).userLogin);
            ((Change)c).ruleName = (String)ruleNamesByKeys.get(((Change)c).ruleKey);
        });
    }

    static class Change {
        private String key;
        private String type;
        private long at;
        private String severity;
        private String userLogin;
        private String userName;
        private String inheritance;
        private RuleKey ruleKey;
        private String ruleName;
        private final Map<String, String> params = new HashMap<String, String>();

        private Change() {
        }

        @VisibleForTesting
        Change(String key, String type, long at, @Nullable String severity, @Nullable String userLogin, @Nullable String userName, @Nullable String inheritance, @Nullable RuleKey ruleKey, @Nullable String ruleName) {
            this.key = key;
            this.type = type;
            this.at = at;
            this.severity = severity;
            this.userLogin = userLogin;
            this.userName = userName;
            this.inheritance = inheritance;
            this.ruleKey = ruleKey;
            this.ruleName = ruleName;
        }

        public String getKey() {
            return this.key;
        }

        @CheckForNull
        public String getSeverity() {
            return this.severity;
        }

        @CheckForNull
        public String getUserLogin() {
            return this.userLogin;
        }

        @CheckForNull
        public String getUserName() {
            return this.userName;
        }

        public String getType() {
            return this.type;
        }

        @CheckForNull
        public String getInheritance() {
            return this.inheritance;
        }

        public RuleKey getRuleKey() {
            return this.ruleKey;
        }

        @CheckForNull
        public String getRuleName() {
            return this.ruleName;
        }

        public long getCreatedAt() {
            return this.at;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        private static Change from(QProfileChangeDto dto) {
            Map data = dto.getDataAsMap();
            Change change = new Change();
            change.key = dto.getUuid();
            change.userLogin = dto.getLogin();
            change.type = dto.getChangeType();
            change.at = dto.getCreatedAt();
            change.severity = (String)data.get("severity");
            String ruleKey = (String)data.get("ruleKey");
            if (ruleKey != null) {
                change.ruleKey = RuleKey.parse((String)ruleKey);
            }
            change.inheritance = (String)data.get("inheritance");
            data.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("param_")).forEach(entry -> change.params.put(((String)entry.getKey()).replace("param_", ""), (String)entry.getValue()));
            return change;
        }
    }
}

