/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.ServerSide;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.ActiveRuleKey;
import org.sonar.db.qualityprofile.ActiveRuleParamDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.RulesProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleParamDto;
import org.sonar.server.qualityprofile.RuleActivatorContext;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class RuleActivatorContextFactory {
    private final DbClient db;

    public RuleActivatorContextFactory(DbClient db) {
        this.db = db;
    }

    RuleActivatorContext createForBuiltIn(DbSession dbSession, RuleKey ruleKey, RulesProfileDto rulesProfile) {
        RuleActivatorContext context = new RuleActivatorContext(rulesProfile);
        return this.init(dbSession, ruleKey, context);
    }

    RuleActivatorContext create(DbSession dbSession, RuleKey ruleKey, QProfileDto profile, boolean cascade) {
        RuleActivatorContext context = new RuleActivatorContext(profile, cascade);
        return this.init(dbSession, ruleKey, context);
    }

    private RuleActivatorContext init(DbSession dbSession, RuleKey ruleKey, RuleActivatorContext context) {
        QProfileDto parent;
        this.initRule(ruleKey, context, dbSession);
        this.initActiveRules(context.getRulesProfile(), ruleKey, context, dbSession, false);
        if (context.getProfile() != null && context.getProfile().getParentKee() != null && (parent = this.db.qualityProfileDao().selectByUuid(dbSession, context.getProfile().getParentKee())) != null) {
            this.initActiveRules(RulesProfileDto.from((QProfileDto)parent), ruleKey, context, dbSession, true);
        }
        return context;
    }

    private RuleDefinitionDto initRule(RuleKey ruleKey, RuleActivatorContext context, DbSession dbSession) {
        Optional<RuleDefinitionDto> rule = this.getRule(dbSession, ruleKey);
        WsUtils.checkRequest(rule.isPresent(), "Rule not found: %s", ruleKey);
        RuleDefinitionDto ruleDefinitionDto = rule.get();
        context.setRule(ruleDefinitionDto);
        context.setRuleParams(this.getRuleParams(dbSession, ruleDefinitionDto));
        return ruleDefinitionDto;
    }

    private void initActiveRules(RulesProfileDto rulesProfile, RuleKey ruleKey, RuleActivatorContext context, DbSession dbSession, boolean isParent) {
        ActiveRuleKey key = ActiveRuleKey.of((RulesProfileDto)rulesProfile, (RuleKey)ruleKey);
        Optional<ActiveRuleDto> activeRule = this.getActiveRule(dbSession, key);
        List<ActiveRuleParamDto> activeRuleParams = null;
        if (activeRule.isPresent()) {
            activeRuleParams = this.getActiveRuleParams(dbSession, activeRule.get());
        }
        if (isParent) {
            context.setParentActiveRule(activeRule.orElse(null));
            context.setParentActiveRuleParams(activeRuleParams);
        } else {
            context.setActiveRule(activeRule.orElse(null));
            context.setActiveRuleParams(activeRuleParams);
        }
    }

    Optional<RuleDefinitionDto> getRule(DbSession dbSession, RuleKey ruleKey) {
        return Optional.ofNullable(this.db.ruleDao().selectDefinitionByKey(dbSession, ruleKey).orElse(null));
    }

    Collection<RuleParamDto> getRuleParams(DbSession dbSession, RuleDefinitionDto ruleDefinitionDto) {
        return this.db.ruleDao().selectRuleParamsByRuleKey(dbSession, ruleDefinitionDto.getKey());
    }

    Optional<ActiveRuleDto> getActiveRule(DbSession dbSession, ActiveRuleKey key) {
        return this.db.activeRuleDao().selectByKey(dbSession, key);
    }

    List<ActiveRuleParamDto> getActiveRuleParams(DbSession dbSession, ActiveRuleDto activeRuleDto) {
        return this.db.activeRuleDao().selectParamsByActiveRuleId(dbSession, activeRuleDto.getId());
    }
}

