/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualitygate.ProjectQgateAssociation;
import org.sonar.db.qualitygate.ProjectQgateAssociationDao;
import org.sonar.db.qualitygate.ProjectQgateAssociationDto;
import org.sonar.db.qualitygate.ProjectQgateAssociationQuery;
import org.sonar.db.qualitygate.QualityGateDao;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class QgateProjectFinder {
    private final DbClient dbClient;
    private final QualityGateDao qualitygateDao;
    private final ProjectQgateAssociationDao associationDao;
    private final UserSession userSession;

    public QgateProjectFinder(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.qualitygateDao = dbClient.qualityGateDao();
        this.associationDao = dbClient.projectQgateAssociationDao();
    }

    public Association find(ProjectQgateAssociationQuery query) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.getQualityGateId(dbSession, query.gateId());
            List projects = this.associationDao.selectProjects(dbSession, query);
            List<ProjectQgateAssociationDto> authorizedProjects = this.keepAuthorizedProjects(dbSession, projects);
            Paging paging = Paging.forPageIndex((int)query.pageIndex()).withPageSize(query.pageSize()).andTotal(authorizedProjects.size());
            Association association = new Association(QgateProjectFinder.toProjectAssociations(QgateProjectFinder.getPaginatedProjects(authorizedProjects, paging)), paging.hasNextPage());
            return association;
        }
    }

    private Long getQualityGateId(DbSession dbSession, String gateId) {
        return WsUtils.checkFound(this.qualitygateDao.selectById(dbSession, Long.valueOf(gateId).longValue()), "Quality gate '" + gateId + "' does not exists.", new Object[0]).getId();
    }

    private static List<ProjectQgateAssociationDto> getPaginatedProjects(List<ProjectQgateAssociationDto> projects, Paging paging) {
        return (List)projects.stream().skip(paging.offset()).limit(paging.pageSize()).collect(MoreCollectors.toList());
    }

    private static List<ProjectQgateAssociation> toProjectAssociations(List<ProjectQgateAssociationDto> dtos) {
        return (List)dtos.stream().map(ProjectQgateAssociationDto::toQgateAssociation).collect(MoreCollectors.toList());
    }

    private List<ProjectQgateAssociationDto> keepAuthorizedProjects(DbSession dbSession, List<ProjectQgateAssociationDto> projects) {
        if (this.userSession.isRoot()) {
            return projects;
        }
        List projectIds = (List)projects.stream().map(ProjectQgateAssociationDto::getId).collect(MoreCollectors.toList());
        Set authorizedProjectIds = this.dbClient.authorizationDao().keepAuthorizedProjectIds(dbSession, (Collection)projectIds, this.userSession.getUserId(), "user");
        return (List)projects.stream().filter(project -> authorizedProjectIds.contains(project.getId())).collect(MoreCollectors.toList());
    }

    public static class Association {
        private List<ProjectQgateAssociation> projects;
        private boolean hasMoreResults;

        private Association(List<ProjectQgateAssociation> projects, boolean hasMoreResults) {
            this.projects = projects;
            this.hasMoreResults = hasMoreResults;
        }

        public List<ProjectQgateAssociation> projects() {
            return this.projects;
        }

        public boolean hasMoreResults() {
            return this.hasMoreResults;
        }
    }
}

