/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectbranch.ws;

import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.MeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.issue.index.BranchStatistics;
import org.sonar.server.issue.index.IssueIndex;
import org.sonar.server.projectbranch.ws.BranchWsAction;
import org.sonar.server.projectbranch.ws.BranchesWs;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.WsBranches;

public class ListAction
implements BranchWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;
    private final IssueIndex issueIndex;

    public ListAction(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder, IssueIndex issueIndex) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
        this.issueIndex = issueIndex;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("list").setSince("6.6").setDescription("List the branches of a project.<br/>Requires 'Browse' or 'Execute analysis' rights on the specified project.").setResponseExample(Resources.getResource(this.getClass(), (String)"list-example.json")).setHandler((RequestHandler)this);
        BranchesWs.addProjectParam(action);
    }

    public void handle(Request request, Response response) throws Exception {
        String projectKey = request.mandatoryParam("project");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto project = this.componentFinder.getByKey(dbSession, projectKey);
            this.checkPermission(project);
            Preconditions.checkArgument((project.isEnabled() && "TRK".equals(project.qualifier()) ? 1 : 0) != 0, (Object)"Invalid project key");
            Collection branches = this.dbClient.branchDao().selectByComponent(dbSession, project);
            MetricDto qualityGateMetric = this.dbClient.metricDao().selectOrFailByKey(dbSession, "alert_status");
            Map mergeBranchesByUuid = (Map)this.dbClient.branchDao().selectByUuids(dbSession, (Collection)branches.stream().map(BranchDto::getMergeBranchUuid).filter(Objects::nonNull).collect(MoreCollectors.toList())).stream().collect(MoreCollectors.uniqueIndex(BranchDto::getUuid));
            Map qualityGateMeasuresByComponentUuids = (Map)this.dbClient.measureDao().selectByComponentsAndMetrics(dbSession, (Collection)branches.stream().map(BranchDto::getUuid).collect(MoreCollectors.toList()), Collections.singletonList(qualityGateMetric.getId())).stream().collect(MoreCollectors.uniqueIndex(MeasureDto::getComponentUuid));
            Map branchStatisticsByBranchUuid = (Map)this.issueIndex.searchBranchStatistics(project.uuid(), (List)branches.stream().filter(b -> b.getBranchType().equals((Object)BranchType.SHORT)).map(BranchDto::getUuid).collect(MoreCollectors.toList())).stream().collect(MoreCollectors.uniqueIndex(BranchStatistics::getBranchUuid, Function.identity()));
            Map analysisDateByBranchUuid = (Map)this.dbClient.snapshotDao().selectLastAnalysesByRootComponentUuids(dbSession, (Collection)branches.stream().map(BranchDto::getUuid).collect(Collectors.toList())).stream().collect(MoreCollectors.uniqueIndex(SnapshotDto::getComponentUuid, s -> DateUtils.formatDateTime((long)s.getCreatedAt())));
            WsBranches.ListWsResponse.Builder protobufResponse = WsBranches.ListWsResponse.newBuilder();
            branches.stream().forEach(b -> ListAction.addBranch(protobufResponse, b, mergeBranchesByUuid, (MeasureDto)qualityGateMeasuresByComponentUuids.get(b.getUuid()), (BranchStatistics)branchStatisticsByBranchUuid.get(b.getUuid()), (String)analysisDateByBranchUuid.get(b.getUuid())));
            WsUtils.writeProtobuf((Message)protobufResponse.build(), request, response);
        }
    }

    private static void addBranch(WsBranches.ListWsResponse.Builder response, BranchDto branch, Map<String, BranchDto> mergeBranchesByUuid, @Nullable MeasureDto qualityGateMeasure, BranchStatistics branchStatistics, @Nullable String analysisDate) {
        WsBranches.Branch.Builder builder = ListAction.toBranchBuilder(branch, Optional.ofNullable(mergeBranchesByUuid.get(branch.getMergeBranchUuid())));
        ListAction.setBranchStatus(builder, branch, qualityGateMeasure, branchStatistics);
        if (analysisDate != null) {
            builder.setAnalysisDate(analysisDate);
        }
        response.addBranches(builder);
    }

    private static WsBranches.Branch.Builder toBranchBuilder(BranchDto branch, Optional<BranchDto> mergeBranch) {
        WsBranches.Branch.Builder builder = WsBranches.Branch.newBuilder();
        String branchKey = branch.getKey();
        Protobuf.setNullable((Object)branchKey, arg_0 -> ((WsBranches.Branch.Builder)builder).setName(arg_0));
        builder.setIsMain(branch.isMain());
        builder.setType(Common.BranchType.valueOf((String)branch.getBranchType().name()));
        if (branch.getBranchType().equals((Object)BranchType.SHORT)) {
            if (mergeBranch.isPresent()) {
                String mergeBranchKey = mergeBranch.get().getKey();
                builder.setMergeBranch(mergeBranchKey);
            } else {
                builder.setIsOrphan(true);
            }
        }
        return builder;
    }

    private static void setBranchStatus(WsBranches.Branch.Builder builder, BranchDto branch, @Nullable MeasureDto qualityGateMeasure, @Nullable BranchStatistics branchStatistics) {
        WsBranches.Branch.Status.Builder statusBuilder = WsBranches.Branch.Status.newBuilder();
        if (branch.getBranchType() == BranchType.LONG && qualityGateMeasure != null) {
            statusBuilder.setQualityGateStatus(qualityGateMeasure.getData());
        }
        if (branch.getBranchType() == BranchType.SHORT) {
            statusBuilder.setBugs(branchStatistics == null ? 0L : branchStatistics.getBugs());
            statusBuilder.setVulnerabilities(branchStatistics == null ? 0L : branchStatistics.getVulnerabilities());
            statusBuilder.setCodeSmells(branchStatistics == null ? 0L : branchStatistics.getCodeSmells());
        }
        builder.setStatus(statusBuilder);
    }

    private void checkPermission(ComponentDto component) {
        if (!(this.userSession.hasComponentPermission("user", component) || this.userSession.hasComponentPermission("scan", component) || this.userSession.hasPermission(OrganizationPermission.SCAN, component.getOrganizationUuid()))) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
    }
}

