/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.component.ComponentCleanerService;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.project.ws.ProjectsWsAction;
import org.sonar.server.user.UserSession;

public class DeleteAction
implements ProjectsWsAction {
    private static final String ACTION = "delete";
    private final ComponentCleanerService componentCleanerService;
    private final ComponentFinder componentFinder;
    private final DbClient dbClient;
    private final UserSession userSession;

    public DeleteAction(ComponentCleanerService componentCleanerService, ComponentFinder componentFinder, DbClient dbClient, UserSession userSession) {
        this.componentCleanerService = componentCleanerService;
        this.componentFinder = componentFinder;
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setPost(true).setDescription("Delete a project.<br> Requires 'Administer System' permission or 'Administer' permission on the project.").setSince("5.2").setHandler((RequestHandler)this);
        action.createParam("projectId").setDescription("Project ID").setDeprecatedKey("id", "6.4").setDeprecatedSince("6.4").setExampleValue((Object)"ce4c03d6-430f-40a9-b777-ad877c00aa4d");
        action.createParam("project").setDescription("Project key").setDeprecatedKey("key", "6.4").setExampleValue((Object)"my_project");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        String uuid = request.param("projectId");
        String key = request.param("project");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto project = this.componentFinder.getByUuidOrKey(dbSession, uuid, key, ComponentFinder.ParamNames.PROJECT_ID_AND_PROJECT);
            this.checkPermission(project);
            this.componentCleanerService.delete(dbSession, project);
        }
        response.noContent();
    }

    private void checkPermission(ComponentDto project) {
        if (!this.userSession.hasComponentPermission("admin", project)) {
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER, project.getOrganizationUuid());
        }
    }
}

