/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins.privileged;

import java.util.List;
import org.sonar.api.platform.Server;
import org.sonar.api.platform.ServerStartHandler;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.plugin.PrivilegedPluginBridge;

public class PrivilegedPluginsBootstraper
implements ServerStartHandler {
    private static final Logger LOGGER = Loggers.get(PrivilegedPluginsBootstraper.class);
    private final ComponentContainer componentContainer;

    public PrivilegedPluginsBootstraper(ComponentContainer componentContainer) {
        this.componentContainer = componentContainer;
    }

    public void onServerStart(Server server) {
        List bridges = this.componentContainer.getComponentsByType(PrivilegedPluginBridge.class);
        for (PrivilegedPluginBridge bridge : bridges) {
            Profiler profiler = Profiler.create((Logger)LOGGER).startInfo(String.format("Bootstrapping %s", bridge.getPluginName()));
            bridge.startPlugin(this.componentContainer);
            profiler.stopInfo();
        }
    }
}

