/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.app.ProcessCommandWrapper;
import org.sonar.server.app.RestartFlagHolder;
import org.sonar.server.platform.WebServer;
import org.sonar.server.platform.ws.SystemWsAction;
import org.sonar.server.user.UserSession;

public class RestartAction
implements SystemWsAction {
    private static final Logger LOGGER = Loggers.get(RestartAction.class);
    private final UserSession userSession;
    private final ProcessCommandWrapper processCommandWrapper;
    private final RestartFlagHolder restartFlagHolder;
    private final WebServer webServer;

    public RestartAction(UserSession userSession, ProcessCommandWrapper processCommandWrapper, RestartFlagHolder restartFlagHolder, WebServer webServer) {
        this.userSession = userSession;
        this.processCommandWrapper = processCommandWrapper;
        this.restartFlagHolder = restartFlagHolder;
        this.webServer = webServer;
    }

    public void define(WebService.NewController controller) {
        controller.createAction("restart").setDescription("Restart server. Require 'Administer System' permission. Perform a full restart of the Web, Search and Compute Engine Servers processes.").setSince("4.3").setPost(true).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) {
        if (!this.webServer.isStandalone()) {
            throw new IllegalArgumentException("Restart not allowed for cluster nodes");
        }
        this.userSession.checkIsSystemAdministrator();
        LOGGER.info("SonarQube restart requested by {}", (Object)this.userSession.getLogin());
        this.restartFlagHolder.set();
        this.processCommandWrapper.requestSQRestart();
    }
}

