/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Locale;
import org.sonar.api.platform.Server;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.core.i18n.DefaultI18n;
import org.sonar.server.ws.WsAction;

public class IndexAction
implements WsAction {
    private static final String LOCALE_PARAM = "locale";
    private static final String TS_PARAM = "ts";
    private final DefaultI18n i18n;
    private final Server server;

    public IndexAction(DefaultI18n i18n, Server server) {
        this.i18n = i18n;
        this.server = server;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction indexAction = context.createAction("index").setInternal(true).setDescription("Get all localization messages for a given locale").setResponseExample(this.getClass().getResource("l10n-index-example.json")).setSince("4.4").setHandler((RequestHandler)this);
        indexAction.createParam(LOCALE_PARAM).setDescription("BCP47 language tag, used to override the browser Accept-Language header").setExampleValue((Object)"fr-CH").setDefaultValue((Object)Locale.ENGLISH.toLanguageTag());
        indexAction.createParam(TS_PARAM).setDescription("Date of the last cache update.").setExampleValue((Object)"2014-06-04T09:31:42+0000");
    }

    public void handle(Request request, Response response) throws Exception {
        Date timestamp = request.paramAsDateTime(TS_PARAM);
        if (timestamp != null && timestamp.after(this.server.getStartedAt())) {
            response.stream().setStatus(304).output().close();
            return;
        }
        String localeParam = request.mandatoryParam(LOCALE_PARAM);
        Locale locale = Locale.forLanguageTag(localeParam);
        Preconditions.checkArgument((!locale.getISO3Language().isEmpty() ? 1 : 0) != 0, (String)"'%s' cannot be parsed as a BCP47 language tag", (Object[])new Object[]{localeParam});
        try (JsonWriter json = response.newJsonWriter();){
            json.beginObject();
            json.prop("effectiveLocale", this.i18n.getEffectiveLocale(locale).toLanguageTag());
            json.name("messages");
            json.beginObject();
            this.i18n.getPropertyKeys().forEach(messageKey -> json.prop(messageKey, this.i18n.message(locale, messageKey, messageKey, new Object[0])));
            json.endObject();
            json.endObject().close();
        }
    }
}

