/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring;

import com.google.common.base.Joiner;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.api.platform.Server;
import org.sonar.api.security.SecurityRealm;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.process.systeminfo.SystemInfoUtils;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;
import org.sonar.server.authentication.IdentityProviderRepository;
import org.sonar.server.platform.ServerLogging;
import org.sonar.server.platform.monitoring.BaseSectionMBean;
import org.sonar.server.platform.monitoring.OfficialDistribution;
import org.sonar.server.platform.monitoring.SystemSectionMBean;
import org.sonar.server.user.SecurityRealmFactory;

public class StandaloneSystemSection
extends BaseSectionMBean
implements SystemSectionMBean {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");
    private final Configuration config;
    private final SecurityRealmFactory securityRealmFactory;
    private final IdentityProviderRepository identityProviderRepository;
    private final Server server;
    private final ServerLogging serverLogging;
    private final OfficialDistribution officialDistribution;

    public StandaloneSystemSection(Configuration config, SecurityRealmFactory securityRealmFactory, IdentityProviderRepository identityProviderRepository, Server server, ServerLogging serverLogging, OfficialDistribution officialDistribution) {
        this.config = config;
        this.securityRealmFactory = securityRealmFactory;
        this.identityProviderRepository = identityProviderRepository;
        this.server = server;
        this.serverLogging = serverLogging;
        this.officialDistribution = officialDistribution;
    }

    @Override
    public String getServerId() {
        return this.server.getId();
    }

    @Override
    public String getVersion() {
        return this.server.getVersion();
    }

    @Override
    public String getLogLevel() {
        return this.serverLogging.getRootLoggerLevel().name();
    }

    @CheckForNull
    private String getExternalUserAuthentication() {
        SecurityRealm realm = this.securityRealmFactory.getRealm();
        return realm == null ? null : realm.getName();
    }

    private List<String> getEnabledIdentityProviders() {
        return (List)this.identityProviderRepository.getAllEnabledAndSorted().stream().filter(IdentityProvider::isEnabled).map(IdentityProvider::getName).collect(MoreCollectors.toList());
    }

    private List<String> getAllowsToSignUpEnabledIdentityProviders() {
        return (List)this.identityProviderRepository.getAllEnabledAndSorted().stream().filter(IdentityProvider::isEnabled).filter(IdentityProvider::allowsUsersToSignUp).map(IdentityProvider::getName).collect(MoreCollectors.toList());
    }

    private boolean getForceAuthentication() {
        return this.config.getBoolean("sonar.forceAuthentication").orElse(false);
    }

    @Override
    public String name() {
        return "SonarQube";
    }

    public ProtobufSystemInfo.Section toProtobuf() {
        ProtobufSystemInfo.Section.Builder protobuf = ProtobufSystemInfo.Section.newBuilder();
        protobuf.setName("System");
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Server ID", (String)this.server.getId());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Version", (String)this.getVersion());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"External User Authentication", (String)this.getExternalUserAuthentication());
        StandaloneSystemSection.addIfNotEmpty(protobuf, "Accepted external identity providers", this.getEnabledIdentityProviders());
        StandaloneSystemSection.addIfNotEmpty(protobuf, "External identity providers whose users are allowed to sign themselves up", this.getAllowsToSignUpEnabledIdentityProviders());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"High Availability", (Boolean)false);
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Official Distribution", (Boolean)this.officialDistribution.check());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Force authentication", (Boolean)this.getForceAuthentication());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Home Dir", (String)this.config.get("sonar.path.home").orElse(null));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Data Dir", (String)this.config.get("sonar.path.data").orElse(null));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Temp Dir", (String)this.config.get("sonar.path.temp").orElse(null));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Processors", (long)Runtime.getRuntime().availableProcessors());
        return protobuf.build();
    }

    private static void addIfNotEmpty(ProtobufSystemInfo.Section.Builder protobuf, String key, @Nullable List<String> values) {
        if (values != null && !values.isEmpty()) {
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)key, (String)COMMA_JOINER.join(values));
        }
    }
}

