/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.dbutils.DbUtils;
import org.picocontainer.Startable;
import org.sonar.api.platform.ServerUpgradeStatus;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.DdlUtils;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.engine.MigrationEngine;
import org.sonar.server.platform.db.migration.step.MigrationSteps;

public class AutoDbMigration
implements Startable {
    private final ServerUpgradeStatus serverUpgradeStatus;
    private final DbClient dbClient;
    private final MigrationEngine migrationEngine;
    private final MigrationSteps migrationSteps;

    public AutoDbMigration(ServerUpgradeStatus serverUpgradeStatus, DbClient dbClient, MigrationEngine migrationEngine, MigrationSteps migrationSteps) {
        this.serverUpgradeStatus = serverUpgradeStatus;
        this.dbClient = dbClient;
        this.migrationEngine = migrationEngine;
        this.migrationSteps = migrationSteps;
    }

    public void start() {
        if (!this.serverUpgradeStatus.isFreshInstall()) {
            return;
        }
        Loggers.get(this.getClass()).info("Automatically perform DB migration on fresh install");
        Dialect dialect = this.dbClient.getDatabase().getDialect();
        if ("h2".equals(dialect.getId())) {
            this.installH2();
        } else {
            this.migrationEngine.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void installH2() {
        Connection connection = null;
        try (DbSession session = this.dbClient.openSession(false);){
            connection = session.getConnection();
            this.createH2Schema(connection, this.dbClient.getDatabase().getDialect().getId());
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(connection);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)connection);
    }

    @VisibleForTesting
    protected void createH2Schema(Connection connection, String dialectId) {
        DdlUtils.createSchema((Connection)connection, (String)dialectId, (boolean)false);
        AutoDbMigration.populateSchemaMigration(connection, this.migrationSteps.getMaxMigrationNumber());
        AutoDbMigration.hackFixForProjectMeasureTreeQueries(connection);
    }

    private static void populateSchemaMigration(Connection connection, long maxMigrationNumber) {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO SCHEMA_MIGRATIONS(VERSION) VALUES (?)");){
            AutoDbMigration.batchExecute(0L, maxMigrationNumber + 1L, preparedStatement, connection, (statement, counter) -> statement.setString(1, String.valueOf(counter)));
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to insert rows into table SCHEMA_MIGRATIONS", e);
        }
    }

    private static void hackFixForProjectMeasureTreeQueries(Connection connection) {
        int metricId = 1;
        try (PreparedStatement preparedStatement = connection.prepareStatement("insert into PROJECT_MEASURES (METRIC_ID,COMPONENT_UUID,ANALYSIS_UUID) values (?,?,?);");){
            AutoDbMigration.batchExecute(1L, 1000L, preparedStatement, connection, (stmt, counter) -> {
                preparedStatement.setInt(1, metricId);
                preparedStatement.setString(2, "foo_" + counter);
                preparedStatement.setString(3, "bar_" + counter);
            });
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to insert fake rows into table PROJECT_MEASURES", e);
        }
    }

    private static void batchExecute(long start, long end, PreparedStatement preparedStatement, Connection connection, Preparer preparer) throws SQLException {
        for (long i = start; i < end; ++i) {
            preparer.prepare(preparedStatement, i);
            preparedStatement.addBatch();
            if (i % 250L != 0L) continue;
            preparedStatement.executeBatch();
            connection.commit();
        }
        preparedStatement.executeBatch();
        connection.commit();
    }

    public void stop() {
    }

    @FunctionalInterface
    private static interface Preparer {
        public void prepare(PreparedStatement var1, long var2) throws SQLException;
    }
}

