/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.join.query.JoinQueryBuilders;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.server.ServerSide;
import org.sonar.db.user.GroupDto;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.NewIndex;
import org.sonar.server.user.UserSession;

@ServerSide
@ComputeEngineSide
public class AuthorizationTypeSupport {
    public static final String TYPE_AUTHORIZATION = "authorization";
    public static final String FIELD_GROUP_IDS = "groupIds";
    public static final String FIELD_USER_IDS = "userIds";
    public static final String FIELD_ALLOW_ANYONE = "allowAnyone";
    private final UserSession userSession;

    public AuthorizationTypeSupport(UserSession userSession) {
        this.userSession = userSession;
    }

    public static IndexType getAuthorizationIndexType(IndexType indexType) {
        Objects.requireNonNull(indexType);
        Objects.requireNonNull(indexType.getIndex());
        Preconditions.checkArgument((!TYPE_AUTHORIZATION.equals(indexType.getType()) ? 1 : 0) != 0, (Object)"Authorization types do not have authorization on their own.");
        return new IndexType(indexType.getIndex(), TYPE_AUTHORIZATION);
    }

    public static NewIndex.NewIndexType enableProjectAuthorization(NewIndex.NewIndexType type) {
        type.setAttribute("_parent", ImmutableMap.of((Object)"type", (Object)TYPE_AUTHORIZATION));
        type.setAttribute("_routing", ImmutableMap.of((Object)"required", (Object)true));
        NewIndex.NewIndexType authType = type.getIndex().createType(TYPE_AUTHORIZATION);
        authType.setAttribute("_routing", ImmutableMap.of((Object)"required", (Object)true));
        authType.createLongField(FIELD_GROUP_IDS);
        authType.createLongField(FIELD_USER_IDS);
        authType.createBooleanField(FIELD_ALLOW_ANYONE);
        authType.setEnableSource(false);
        return type;
    }

    public QueryBuilder createQueryFilter() {
        if (this.userSession.isRoot()) {
            return QueryBuilders.matchAllQuery();
        }
        Integer userId = this.userSession.getUserId();
        BoolQueryBuilder filter = QueryBuilders.boolQuery();
        filter.should((QueryBuilder)QueryBuilders.termQuery((String)FIELD_ALLOW_ANYONE, (boolean)true));
        Optional.ofNullable(userId).map(Integer::longValue).ifPresent(id -> filter.should((QueryBuilder)QueryBuilders.termQuery((String)FIELD_USER_IDS, (Object)id)));
        this.userSession.getGroups().stream().map(GroupDto::getId).forEach(groupId -> filter.should((QueryBuilder)QueryBuilders.termQuery((String)FIELD_GROUP_IDS, (Object)groupId)));
        return JoinQueryBuilders.hasParentQuery((String)TYPE_AUTHORIZATION, (QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)filter), (boolean)false);
    }
}

