/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.i18n.I18n;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentTreeQuery;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.measure.ws.ComponentDtoToWsComponent;
import org.sonar.server.measure.ws.ComponentTreeData;
import org.sonar.server.measure.ws.ComponentTreeDataLoader;
import org.sonar.server.measure.ws.MeasureDtoToWsMeasure;
import org.sonar.server.measure.ws.MeasuresWsAction;
import org.sonar.server.measure.ws.MeasuresWsParametersBuilder;
import org.sonar.server.measure.ws.MetricDtoToWsMetric;
import org.sonar.server.ws.WsParameterBuilder;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsMeasures;
import org.sonarqube.ws.client.measure.ComponentTreeWsRequest;

public class ComponentTreeAction
implements MeasuresWsAction {
    private static final int MAX_SIZE = 500;
    private static final int QUERY_MINIMUM_LENGTH = 3;
    static final String ALL_STRATEGY = "all";
    static final String CHILDREN_STRATEGY = "children";
    static final String LEAVES_STRATEGY = "leaves";
    static final Map<String, ComponentTreeQuery.Strategy> STRATEGIES = ImmutableMap.of((Object)"all", (Object)ComponentTreeQuery.Strategy.LEAVES, (Object)"children", (Object)ComponentTreeQuery.Strategy.CHILDREN, (Object)"leaves", (Object)ComponentTreeQuery.Strategy.LEAVES);
    static final String NAME_SORT = "name";
    static final String PATH_SORT = "path";
    static final String QUALIFIER_SORT = "qualifier";
    static final String METRIC_SORT = "metric";
    static final String METRIC_PERIOD_SORT = "metricPeriod";
    static final Set<String> SORTS = ImmutableSortedSet.of((Comparable)((Object)"name"), (Comparable)((Object)"path"), (Comparable)((Object)"qualifier"), (Comparable)((Object)"metric"), (Comparable)((Object)"metricPeriod"));
    static final String ALL_METRIC_SORT_FILTER = "all";
    static final String WITH_MEASURES_ONLY_METRIC_SORT_FILTER = "withMeasuresOnly";
    static final Set<String> METRIC_SORT_FILTERS = ImmutableSortedSet.of((Comparable)((Object)"all"), (Comparable)((Object)"withMeasuresOnly"));
    static final Set<String> FORBIDDEN_METRIC_TYPES = ImmutableSet.of((Object)Metric.ValueType.DISTRIB.name(), (Object)Metric.ValueType.DATA.name());
    private static final int MAX_METRIC_KEYS = 15;
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");
    private final ComponentTreeDataLoader dataLoader;
    private final I18n i18n;
    private final ResourceTypes resourceTypes;

    public ComponentTreeAction(ComponentTreeDataLoader dataLoader, I18n i18n, ResourceTypes resourceTypes) {
        this.dataLoader = dataLoader;
        this.i18n = i18n;
        this.resourceTypes = resourceTypes;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("component_tree").setDescription(String.format("Navigate through components based on the chosen strategy with specified measures. The %s or the %s parameter must be provided.<br>Requires the following permission: 'Browse' on the specified project.<br>When limiting search with the %s parameter, directories are not returned.", "baseComponentId", "component", "q")).setResponseExample(this.getClass().getResource("component_tree-example.json")).setSince("5.4").setHandler((RequestHandler)this).addPagingParams(100, 500).setChangelog(new Change[]{new Change("6.3", String.format("Number of metric keys is limited to %s", 15)), new Change("6.6", "the response field id is deprecated. Use key instead."), new Change("6.6", "the response field refId is deprecated. Use refKey instead.")});
        action.createSortParams(SORTS, (Object)NAME_SORT, true).setDescription("Comma-separated list of sort fields").setExampleValue((Object)"name,path");
        action.createParam("q").setDescription(String.format("Limit search to: <ul><li>component names that contain the supplied string</li><li>component keys that are exactly the same as the supplied string</li></ul>Must have at least %d characters.", 3)).setExampleValue((Object)"FILE_NAM");
        action.createParam("baseComponentId").setDescription("Base component id. The search is based on this component.").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FLz").setDeprecatedSince("6.6");
        action.createParam("component").setDescription("Component key. The search is based on this component.").setExampleValue((Object)"my_project").setDeprecatedKey("baseComponentKey", "6.6");
        action.createParam("branch").setDescription("Branch key").setExampleValue((Object)"feature/my_branch").setInternal(true).setSince("6.6");
        action.createParam("metricSort").setDescription(String.format("Metric key to sort by. The '%s' parameter must contain the '%s' or '%s' value. It must be part of the '%s' parameter", "s", METRIC_SORT, METRIC_PERIOD_SORT, "metricKeys")).setExampleValue((Object)"ncloc");
        action.createParam("metricPeriodSort").setDescription(String.format("Sort measures by leak period or not ?. The '%s' parameter must contain the '%s' value.", "s", METRIC_PERIOD_SORT)).setSince("5.5").setPossibleValues(new Object[]{1});
        action.createParam("metricSortFilter").setDescription(String.format("Filter components. Sort must be on a metric. Possible values are: <ul><li>%s: return all components</li><li>%s: filter out components that do not have a measure on the sorted metric</li></ul>", "all", WITH_MEASURES_ONLY_METRIC_SORT_FILTER)).setDefaultValue((Object)"all").setPossibleValues(METRIC_SORT_FILTERS);
        MeasuresWsParametersBuilder.createMetricKeysParameter(action).setDescription("Metric keys. Types %s are not allowed", new Object[]{COMMA_JOINER.join(FORBIDDEN_METRIC_TYPES)}).setMaxValuesAllowed(Integer.valueOf(15));
        MeasuresWsParametersBuilder.createAdditionalFieldsParameter(action);
        MeasuresWsParametersBuilder.createDeveloperParameters(action);
        WsParameterBuilder.createQualifiersParameter(action, WsParameterBuilder.QualifierParameterContext.newQualifierParameterContext(this.i18n, this.resourceTypes));
        action.createParam("strategy").setDescription("Strategy to search for base component descendants:<ul><li>children: return the children components of the base component. Grandchildren components are not returned</li><li>all: return all the descendants components of the base component. Grandchildren are returned.</li><li>leaves: return all the descendant components (files, in general) which don't have other children. They are the leaves of the component tree.</li></ul>").setPossibleValues(STRATEGIES.keySet()).setDefaultValue((Object)"all");
    }

    public void handle(Request request, Response response) throws Exception {
        WsMeasures.ComponentTreeWsResponse componentTreeWsResponse = this.doHandle(ComponentTreeAction.toComponentTreeWsRequest(request));
        WsUtils.writeProtobuf((Message)componentTreeWsResponse, request, response);
    }

    private WsMeasures.ComponentTreeWsResponse doHandle(ComponentTreeWsRequest request) {
        ComponentTreeData data = this.dataLoader.load(request);
        if (data.getComponents() == null) {
            return ComponentTreeAction.emptyResponse(data.getBaseComponent(), request);
        }
        return ComponentTreeAction.buildResponse(request, data, Paging.forPageIndex((int)request.getPage()).withPageSize(request.getPageSize().intValue()).andTotal(data.getComponentCount()));
    }

    private static WsMeasures.ComponentTreeWsResponse buildResponse(ComponentTreeWsRequest request, ComponentTreeData data, Paging paging) {
        WsMeasures.ComponentTreeWsResponse.Builder response = WsMeasures.ComponentTreeWsResponse.newBuilder();
        response.getPagingBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total()).build();
        response.setBaseComponent(ComponentTreeAction.toWsComponent(data.getBaseComponent(), data.getMeasuresByComponentUuidAndMetric().row((Object)data.getBaseComponent().uuid()), data.getReferenceComponentsByUuid()));
        for (ComponentDto componentDto : data.getComponents()) {
            response.addComponents(ComponentTreeAction.toWsComponent(componentDto, data.getMeasuresByComponentUuidAndMetric().row((Object)componentDto.uuid()), data.getReferenceComponentsByUuid()));
        }
        if (ComponentTreeAction.areMetricsInResponse(request)) {
            WsMeasures.Metrics.Builder metricsBuilder = response.getMetricsBuilder();
            for (MetricDto metricDto : data.getMetrics()) {
                metricsBuilder.addMetrics(MetricDtoToWsMetric.metricDtoToWsMetric(metricDto));
            }
        }
        if (ComponentTreeAction.arePeriodsInResponse(request)) {
            response.getPeriodsBuilder().addAllPeriods(data.getPeriods());
        }
        return response.build();
    }

    private static boolean areMetricsInResponse(ComponentTreeWsRequest request) {
        return request.getAdditionalFields() != null && request.getAdditionalFields().contains("metrics");
    }

    private static boolean arePeriodsInResponse(ComponentTreeWsRequest request) {
        return request.getAdditionalFields() != null && request.getAdditionalFields().contains("periods");
    }

    private static WsMeasures.ComponentTreeWsResponse emptyResponse(ComponentDto baseComponent, ComponentTreeWsRequest request) {
        WsMeasures.ComponentTreeWsResponse.Builder response = WsMeasures.ComponentTreeWsResponse.newBuilder();
        response.getPagingBuilder().setPageIndex(request.getPage().intValue()).setPageSize(request.getPageSize().intValue()).setTotal(0);
        response.setBaseComponent(ComponentDtoToWsComponent.componentDtoToWsComponent(baseComponent));
        return response.build();
    }

    private static ComponentTreeWsRequest toComponentTreeWsRequest(Request request) {
        List metricKeys = request.mandatoryParamAsStrings("metricKeys");
        Preconditions.checkArgument((metricKeys.size() <= 15 ? 1 : 0) != 0, (String)"Number of metrics keys is limited to %s, got %s", (Object[])new Object[]{15, metricKeys.size()});
        ComponentTreeWsRequest componentTreeWsRequest = new ComponentTreeWsRequest().setBaseComponentId(request.param("baseComponentId")).setComponent(request.param("component")).setBranch(request.param("branch")).setMetricKeys(metricKeys).setStrategy(request.mandatoryParam("strategy")).setQualifiers(request.paramAsStrings("qualifiers")).setAdditionalFields(request.paramAsStrings("additionalFields")).setSort(request.paramAsStrings("s")).setAsc(request.paramAsBoolean("asc")).setMetricSort(request.param("metricSort")).setMetricSortFilter(request.mandatoryParam("metricSortFilter")).setMetricPeriodSort(request.paramAsInt("metricPeriodSort")).setDeveloperId(request.param("developerId")).setDeveloperKey(request.param("developerKey")).setPage(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).setQuery(request.param("q"));
        WsUtils.checkRequest(componentTreeWsRequest.getPageSize() <= 500, "The '%s' parameter must be less than %d", "ps", 500);
        String searchQuery = componentTreeWsRequest.getQuery();
        WsUtils.checkRequest(searchQuery == null || searchQuery.length() >= 3, "The '%s' parameter must have at least %d characters", "q", 3);
        String metricSortValue = componentTreeWsRequest.getMetricSort();
        WsUtils.checkRequest(!componentTreeWsRequest.getMetricKeys().isEmpty(), "The '%s' parameter must contain at least one metric key", "metricKeys");
        List sorts = Optional.ofNullable(componentTreeWsRequest.getSort()).orElse(Collections.emptyList());
        WsUtils.checkRequest(metricSortValue == null ^ sorts.contains(METRIC_SORT) ^ sorts.contains(METRIC_PERIOD_SORT), "To sort by a metric, the '%s' parameter must contain '%s' or '%s', and a metric key must be provided in the '%s' parameter", "s", METRIC_SORT, METRIC_PERIOD_SORT, "metricSort");
        WsUtils.checkRequest(metricSortValue == null ^ componentTreeWsRequest.getMetricKeys().contains(metricSortValue), "To sort by the '%s' metric, it must be in the list of metric keys in the '%s' parameter", metricSortValue, "metricKeys");
        WsUtils.checkRequest(componentTreeWsRequest.getMetricPeriodSort() == null ^ sorts.contains(METRIC_PERIOD_SORT), "To sort by a metric period, the '%s' parameter must contain '%s' and the '%s' must be provided.", "s", METRIC_PERIOD_SORT, "metricPeriodSort");
        WsUtils.checkRequest("all".equals(componentTreeWsRequest.getMetricSortFilter()) || metricSortValue != null, "To filter components based on the sort metric, the '%s' parameter must contain '%s' or '%s' and the '%s' parameter must be provided", "s", METRIC_SORT, METRIC_PERIOD_SORT, "metricSort");
        return componentTreeWsRequest;
    }

    private static WsMeasures.Component.Builder toWsComponent(ComponentDto component, Map<MetricDto, ComponentTreeData.Measure> measures, Map<String, ComponentDto> referenceComponentsByUuid) {
        WsMeasures.Component.Builder wsComponent = ComponentDtoToWsComponent.componentDtoToWsComponent(component);
        ComponentDto referenceComponent = referenceComponentsByUuid.get(component.getCopyResourceUuid());
        if (referenceComponent != null) {
            wsComponent.setRefId(referenceComponent.uuid());
            wsComponent.setRefKey(referenceComponent.getDbKey());
        }
        WsMeasures.Measure.Builder measureBuilder = WsMeasures.Measure.newBuilder();
        for (Map.Entry<MetricDto, ComponentTreeData.Measure> entry : measures.entrySet()) {
            ComponentTreeData.Measure measure = entry.getValue();
            MeasureDtoToWsMeasure.updateMeasureBuilder(measureBuilder, entry.getKey(), measure.getValue(), measure.getData(), measure.getVariation());
            wsComponent.addMeasures(measureBuilder);
            measureBuilder.clear();
        }
        return wsComponent;
    }
}

