/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonarqube.ws.client.issue.SearchWsRequest;

public enum SearchAdditionalField {
    ACTIONS("actions"),
    DEPRECATED_ACTION_PLANS("actionPlans"),
    COMMENTS("comments"),
    LANGUAGES("languages"),
    RULES("rules"),
    TRANSITIONS("transitions"),
    USERS("users");

    public static final String ALL_ALIAS = "_all";
    static final EnumSet<SearchAdditionalField> ALL_ADDITIONAL_FIELDS;
    private static final Map<String, SearchAdditionalField> BY_LABELS;
    private final String label;

    private SearchAdditionalField(String label) {
        this.label = label;
    }

    @CheckForNull
    public static SearchAdditionalField findByLabel(String label) {
        return BY_LABELS.get(label);
    }

    public static Collection<String> possibleValues() {
        ArrayList possibles = Lists.newArrayList((Object[])new String[]{ALL_ALIAS});
        possibles.addAll(BY_LABELS.keySet());
        return possibles;
    }

    public static EnumSet<SearchAdditionalField> getFromRequest(SearchWsRequest request) {
        List labels = request.getAdditionalFields();
        if (labels == null) {
            return EnumSet.noneOf(SearchAdditionalField.class);
        }
        EnumSet<SearchAdditionalField> fields = EnumSet.noneOf(SearchAdditionalField.class);
        for (String label : labels) {
            if (label.equals(ALL_ALIAS)) {
                return EnumSet.allOf(SearchAdditionalField.class);
            }
            fields.add(SearchAdditionalField.findByLabel(label));
        }
        return fields;
    }

    static {
        ALL_ADDITIONAL_FIELDS = EnumSet.allOf(SearchAdditionalField.class);
        BY_LABELS = new HashMap<String, SearchAdditionalField>();
        for (SearchAdditionalField f : SearchAdditionalField.values()) {
            BY_LABELS.put(f.label, f);
        }
    }
}

