/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.io.Resources;
import java.util.Collections;
import java.util.Map;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.server.issue.IssueQuery;
import org.sonar.server.issue.IssueQueryFactory;
import org.sonar.server.issue.index.IssueIndex;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonarqube.ws.client.issue.SearchWsRequest;

public class ComponentTagsAction
implements IssuesWsAction {
    private final IssueIndex issueIndex;
    private final IssueQueryFactory queryService;

    public ComponentTagsAction(IssueIndex issueIndex, IssueQueryFactory queryService) {
        this.issueIndex = issueIndex;
        this.queryService = queryService;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("component_tags").setHandler((RequestHandler)this).setSince("5.1").setInternal(true).setDescription("List tags for the issues under a given component (including issues on the descendants of the component)").setResponseExample(Resources.getResource(this.getClass(), (String)"component-tags-example.json"));
        action.createParam("componentUuid").setDescription("A component UUID").setRequired(true).setExampleValue((Object)"7d8749e8-3070-4903-9188-bdd82933bb92");
        action.createParam("createdAfter").setDescription("To retrieve tags on issues created after the given date (inclusive). <br>Either a date (server timezone) or datetime can be provided.").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
        action.createParam("ps").setDescription("The maximum size of the list to return").setExampleValue((Object)"25").setDefaultValue((Object)"10");
    }

    public void handle(Request request, Response response) throws Exception {
        SearchWsRequest searchWsRequest = new SearchWsRequest().setComponentUuids(Collections.singletonList(request.mandatoryParam("componentUuid"))).setResolved(Boolean.valueOf(false)).setCreatedAfter(request.param("createdAfter"));
        IssueQuery query = this.queryService.create(searchWsRequest);
        int pageSize = request.mandatoryParamAsInt("ps");
        try (JsonWriter json = response.newJsonWriter();){
            json.beginObject().name("tags").beginArray();
            for (Map.Entry<String, Long> tag : this.issueIndex.countTags(query, pageSize).entrySet()) {
                json.beginObject().prop("key", tag.getKey()).prop("value", (Number)tag.getValue()).endObject();
            }
            json.endArray().endObject();
        }
    }
}

