/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.workflow;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.server.issue.workflow.State;
import org.sonar.server.issue.workflow.Transition;

public class StateMachine {
    private final List<String> keys;
    private final Map<String, State> byKey;

    private StateMachine(Builder builder) {
        this.keys = ImmutableList.copyOf((Collection)builder.states);
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (String stateKey : builder.states) {
            List outTransitions = builder.outTransitions.get((Object)stateKey);
            State state = new State(stateKey, outTransitions.toArray(new Transition[outTransitions.size()]));
            mapBuilder.put((Object)stateKey, (Object)state);
        }
        this.byKey = mapBuilder.build();
    }

    @CheckForNull
    public State state(String stateKey) {
        return this.byKey.get(stateKey);
    }

    public List<String> stateKeys() {
        return this.keys;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<String> states = new LinkedHashSet<String>();
        private final ListMultimap<String, Transition> outTransitions = ArrayListMultimap.create();

        private Builder() {
        }

        public Builder states(String ... keys) {
            this.states.addAll(Arrays.asList(keys));
            return this;
        }

        public Builder transition(Transition transition) {
            Preconditions.checkArgument((boolean)this.states.contains(transition.from()), (Object)("Originating state does not exist: " + transition.from()));
            Preconditions.checkArgument((boolean)this.states.contains(transition.to()), (Object)("Destination state does not exist: " + transition.to()));
            this.outTransitions.put((Object)transition.from(), (Object)transition);
            return this;
        }

        public StateMachine build() {
            Preconditions.checkArgument((!this.states.isEmpty() ? 1 : 0) != 0, (Object)"At least one state is required");
            return new StateMachine(this);
        }
    }
}

