/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.favorite;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.property.PropertyDto;
import org.sonar.db.property.PropertyQuery;
import org.sonar.server.user.UserSession;

public class FavoriteFinder {
    private final DbClient dbClient;
    private final UserSession userSession;

    public FavoriteFinder(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public List<ComponentDto> list() {
        if (!this.userSession.isLoggedIn()) {
            return Collections.emptyList();
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            PropertyQuery dbQuery = PropertyQuery.builder().setKey("favourite").setUserId(this.userSession.getUserId()).build();
            Set componentIds = this.dbClient.propertiesDao().selectByQuery(dbQuery, dbSession).stream().map(PropertyDto::getResourceId).collect(Collectors.toSet());
            List list = (List)this.dbClient.componentDao().selectByIds(dbSession, componentIds).stream().sorted(Comparator.comparing(ComponentDto::name)).collect(MoreCollectors.toList());
            return list;
        }
    }
}

