/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.textsearch;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.es.DefaultIndexSettingsElement;
import org.sonar.server.es.textsearch.ComponentTextSearchFeature;
import org.sonar.server.es.textsearch.ComponentTextSearchQueryFactory;

public enum ComponentTextSearchFeatureRepertoire implements ComponentTextSearchFeature
{
    EXACT_IGNORE_CASE(ComponentTextSearchFeature.UseCase.CHANGE_ORDER_OF_RESULTS){

        @Override
        public QueryBuilder getQuery(ComponentTextSearchQueryFactory.ComponentTextSearchQuery query) {
            return QueryBuilders.matchQuery((String)DefaultIndexSettingsElement.SORTABLE_ANALYZER.subField(query.getFieldName()), (Object)query.getQueryText()).boost(2.5f);
        }
    }
    ,
    PREFIX(ComponentTextSearchFeature.UseCase.CHANGE_ORDER_OF_RESULTS){

        @Override
        public Stream<QueryBuilder> getQueries(ComponentTextSearchQueryFactory.ComponentTextSearchQuery query) {
            List<String> tokens = query.getQueryTextTokens();
            if (tokens.isEmpty()) {
                return Stream.empty();
            }
            BoolQueryBuilder queryBuilder = (BoolQueryBuilder)this.prefixAndPartialQuery(tokens, query.getFieldName(), DefaultIndexSettingsElement.SEARCH_PREFIX_ANALYZER).boost(3.0f);
            return Stream.of(queryBuilder);
        }
    }
    ,
    PREFIX_IGNORE_CASE(ComponentTextSearchFeature.UseCase.GENERATE_RESULTS){

        @Override
        public Stream<QueryBuilder> getQueries(ComponentTextSearchQueryFactory.ComponentTextSearchQuery query) {
            List<String> tokens = query.getQueryTextTokens();
            if (tokens.isEmpty()) {
                return Stream.empty();
            }
            List lowerCaseTokens = (List)tokens.stream().map(t -> t.toLowerCase(Locale.ENGLISH)).collect(MoreCollectors.toList());
            BoolQueryBuilder queryBuilder = (BoolQueryBuilder)this.prefixAndPartialQuery(lowerCaseTokens, query.getFieldName(), DefaultIndexSettingsElement.SEARCH_PREFIX_CASE_INSENSITIVE_ANALYZER).boost(2.0f);
            return Stream.of(queryBuilder);
        }
    }
    ,
    PARTIAL(ComponentTextSearchFeature.UseCase.GENERATE_RESULTS){

        @Override
        public Stream<QueryBuilder> getQueries(ComponentTextSearchQueryFactory.ComponentTextSearchQuery query) {
            List<String> tokens = query.getQueryTextTokens();
            if (tokens.isEmpty()) {
                return Stream.empty();
            }
            BoolQueryBuilder queryBuilder = (BoolQueryBuilder)QueryBuilders.boolQuery().boost(0.5f);
            tokens.stream().map(text -> this.tokenQuery((String)text, query.getFieldName(), DefaultIndexSettingsElement.SEARCH_GRAMS_ANALYZER)).forEach(arg_0 -> ((BoolQueryBuilder)queryBuilder).must(arg_0));
            return Stream.of(queryBuilder);
        }
    }
    ,
    KEY(ComponentTextSearchFeature.UseCase.GENERATE_RESULTS){

        @Override
        public QueryBuilder getQuery(ComponentTextSearchQueryFactory.ComponentTextSearchQuery query) {
            return QueryBuilders.matchQuery((String)DefaultIndexSettingsElement.SORTABLE_ANALYZER.subField(query.getFieldKey()), (Object)query.getQueryText()).boost(50.0f);
        }
    }
    ,
    RECENTLY_BROWSED(ComponentTextSearchFeature.UseCase.CHANGE_ORDER_OF_RESULTS){

        @Override
        public Stream<QueryBuilder> getQueries(ComponentTextSearchQueryFactory.ComponentTextSearchQuery query) {
            Set<String> recentlyBrowsedKeys = query.getRecentlyBrowsedKeys();
            if (recentlyBrowsedKeys.isEmpty()) {
                return Stream.empty();
            }
            return Stream.of(QueryBuilders.termsQuery((String)query.getFieldKey(), recentlyBrowsedKeys).boost(100.0f));
        }
    }
    ,
    FAVORITE(ComponentTextSearchFeature.UseCase.CHANGE_ORDER_OF_RESULTS){

        @Override
        public Stream<QueryBuilder> getQueries(ComponentTextSearchQueryFactory.ComponentTextSearchQuery query) {
            Set<String> favoriteKeys = query.getFavoriteKeys();
            if (favoriteKeys.isEmpty()) {
                return Stream.empty();
            }
            return Stream.of(QueryBuilders.termsQuery((String)query.getFieldKey(), favoriteKeys).boost(1000.0f));
        }
    };

    private final ComponentTextSearchFeature.UseCase useCase;

    private ComponentTextSearchFeatureRepertoire(ComponentTextSearchFeature.UseCase useCase) {
        this.useCase = useCase;
    }

    @Override
    public QueryBuilder getQuery(ComponentTextSearchQueryFactory.ComponentTextSearchQuery query) {
        throw new UnsupportedOperationException();
    }

    protected BoolQueryBuilder prefixAndPartialQuery(List<String> tokens, String originalFieldName, DefaultIndexSettingsElement analyzer) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        AtomicBoolean first = new AtomicBoolean(true);
        tokens.stream().map(queryTerm -> {
            if (first.getAndSet(false)) {
                return this.tokenQuery((String)queryTerm, originalFieldName, analyzer);
            }
            return this.tokenQuery((String)queryTerm, originalFieldName, DefaultIndexSettingsElement.SEARCH_GRAMS_ANALYZER);
        }).forEach(arg_0 -> ((BoolQueryBuilder)queryBuilder).must(arg_0));
        return queryBuilder;
    }

    protected MatchQueryBuilder tokenQuery(String queryTerm, String fieldName, DefaultIndexSettingsElement analyzer) {
        String truncatedQuery = StringUtils.left((String)queryTerm, (int)15);
        return QueryBuilders.matchQuery((String)analyzer.subField(fieldName), (Object)truncatedQuery);
    }

    @Override
    public ComponentTextSearchFeature.UseCase getUseCase() {
        return this.useCase;
    }
}

